%define version 1.1.21
%define release alt3
%setup_python_module psycopg

Summary: psycopg is a PostgreSQL database adapter for Python
Name: %packagename
Version: %version
Release: %release.1
Source0: %modulename-%version.tar.gz
Patch0: psycopg-logging.patch
License: GPL
Group: Databases
URL: http://www.initd.org/software/psycopg/
BuildRequires(pre): rpm-build-python
BuildRequires: postgresql-devel python%__python_package_version-module-egenix-mx-base
Obsoletes: psycopg <= 1.1.9-alt4
Requires: python%_python_version(mx)
Packager: Python Development Team <python@packages.altlinux.org>
%def_without ZPsycopgDA

%description
psycopg is a PostgreSQL database adapter for the Python programming
language (just like pygresql and popy.) It was written from scratch with
the aim of being very small and fast, and stable as a rock. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

%package doc
Summary: Documentation for psycopg python PostgreSQL database adapter
Group: Databases

%description doc
Documenation and example files for the psycopg python PostgreSQL
database adapter.

%package ZPsycopgDA
Summary: psycopg PostgreSQL database adapter for Zope
Group: System/Servers/ZProducts
Requires: Zope-Modules

%description ZPsycopgDA
ZPsycopgDA is a PostgreSQL database adapter for the Zope application
server. It used psycopg database adapter. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

#%package GeoTypes
#Summary: Classes for working with basic 2d geometric types
#Group: Development/Python
#
#%description GeoTypes
#A package of classes for working with basic 2d geometric types.
#
#These classes were designed for use with the geometric functions
#supported by Postgresql (http://www.postgresql.com) although they
#do not need Postgresql to be present for them to be used.

%prep
%setup -n %modulename-%version
%patch0 -p1

%build
%configure --with-python=python \
      --with-mxdatetime-includes=%python_sitelibdir/mx/DateTime/mxDateTime \
      --with-postgres-includes=%_includedir/pgsql
make

#pushd GeoTypes
#%__python setup.py build
#popd

%install
install -pDm644 psycopgmodule.so %buildroot%python_dynlibdir/psycopg.so
%if_with ZPsycopgDA
mkdir -p $RPM_BUILD_ROOT/usr/lib/zope/lib/python/Products
install -d ZPsycopgDA $RPM_BUILD_ROOT/usr/lib/zope/lib/python/Products/ZPsycopgDA
install -m 644 ZPsycopgDA/*{py,dtml} $RPM_BUILD_ROOT/usr/lib/zope/lib/python/Products/ZPsycopgDA
install -d ZPsycopgDA/icons $RPM_BUILD_ROOT/usr/lib/zope/lib/python/Products/ZPsycopgDA/icons
install -m 644 ZPsycopgDA/icons/* $RPM_BUILD_ROOT/usr/lib/zope/lib/python/Products/ZPsycopgDA/icons
%endif

#pushd GeoTypes
#%__python setup.py install --root=$RPM_BUILD_ROOT --optimize=2 --record=INSTALLED_FILES
#popd

%files
%python_dynlibdir/*

%files doc
%doc AUTHORS  COPYING  CREDITS  FAQ  INSTALL  NEWS  README  RELEASE-1.0  SUCCESS  TODO doc

%if_with ZPsycopgDA
%files ZPsycopgDA
/usr/lib/zope/lib/python/Products/ZPsycopgDA
%endif

#%files GeoTypes -f GeoTypes/INSTALLED_FILES
#%defattr(-,root,root)

%changelog
