Name: python-module-py9p
Version: 1.0.7
Release: alt2
Summary: Pure Python implementation of 9P protocol (Plan9)
License: MIT
Group: Development/Python
URL: https://github.com/svinota/py9p

BuildArch: noarch
BuildPreReq: python-devel rpm-build-python
Source: py9p-%version.tar.gz

%description
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This library provides low-level 9p2000.u API. For high-level look
into python-module-pyvfs.

%package -n fuse9p
Summary: Plan9 filesystem client for FUSE
License: MIT
Group: Development/Python
URL: https://github.com/svinota/py9p
Requires: %name = %version-%release

%description -n fuse9p
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This package contains FUSE client for the 9p protocol.

%package -n 9pfs
Summary: Plan9 filesystem server
License: MIT
Group: Development/Python
URL: https://github.com/svinota/py9p
Requires: %name = %version-%release

%description -n 9pfs
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This package contains simple 9p2000 file server.

%prep
%setup -q -n py9p-%{version}

%install
%{__python} setup.py install --root=%buildroot --install-lib=%{python_sitelibdir}

%files
%doc README* LICENSE
%{python_sitelibdir}/py9p*

%files -n fuse9p
%_bindir/fuse9p
%_man1dir/fuse9p.*

%files -n 9pfs
%_bindir/9pfs
%_man1dir/9pfs.*

%changelog
