%define oname pycairo
Name: python-module-%oname
Version: 1.10.1
Release: alt2.git20120522

Summary: Pycairo is a set of Python bindings for the vector graphics library cairo

License: GPL
Group: Development/Python
Url: http://www.cairographics.org/pycairo

Packager: Vitaly Lipatov <lav@altlinux.ru>

# git://git.cairographics.org/git/py2cairo
Source: pycairo-%version.tar.gz

%setup_python_module cairo

# Automatically added by buildreq on Wed Jul 01 2009
BuildRequires: gcc-c++ libcairo-devel python-devel
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: texlive-latex-base

BuildRequires: libcairo-devel >= 1.8.6

%description
James Henstridge has created cairo bindings for Python.
Cairo is a library for drawing vector graphics.
Vector graphics are interesting because when they appear on screen,
they don't lose clarity when resized or transformed.

%package devel
Summary: Development files for pycairo
Group: Development/Python
Requires: %name = %version-%release
#Requires: %name-pickles = %version-%release

%description devel
Development files for pycairo.

%package docs
Summary: Documentation for pycairo
Group: Development/Documentation
BuildArch: noarch

%description docs
Documentation for pycairo.

%package tests
Summary: Tests for pycairo
Group: Development/Python
Requires: %name = %version-%release

%description tests
Documentation for pycairo.

%package examples
Summary: Examples for pycairo
Group: Development/Python
Requires: %name = %version-%release

%description examples
Examples for pycairo.

%package pickles
Summary: Pickles for pycairo
Group: Development/Python

%description pickles
Pickles for pycairo.

%prep
%setup

sed -i 's|@PYVER@|%_python_version|g' doc/Makefile.am

%prepare_sphinx doc

%build
#rm -r aclocal.m4 ltmain.sh
#autoreconf
./autogen.sh
%configure
%make_build
# FIXME: run with built pycairo
#echo "import cairo" >test-cairo.py
#%_bindir/env python test-cairo.py

pushd doc
%make_build html
popd

%install
%makeinstall_std

# docs

install -d %buildroot%_docdir/%name-%version
install -p -m644 AUTHORS COPYING-* NEWS README \
	%buildroot%_docdir/%name-%version

cp -fR doc/.build/html %buildroot%_docdir/%name-%version/
#cp -fR doc/.build/latex/*.pdf %buildroot%_docdir/%name-%version/pdf

# pickles

install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

# tests and examples

cp -fR examples test %buildroot%python_sitelibdir/%modulename/
for i in $(find %buildroot%python_sitelibdir/%modulename/examples -type d)
do
	touch $i/__init__.py
done

%pre pickles
rm -fR %python_sitelibdir/%oname/pickle

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/AUTHORS
%doc %_docdir/%name-%version/COPYING-*
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README
%python_sitelibdir/%modulename
%exclude %python_sitelibdir/%modulename/test
%exclude %python_sitelibdir/%modulename/examples

%files devel
%_includedir/%oname
%_pkgconfigdir/%oname.pc

%files docs
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version
%exclude %_docdir/%name-%version/AUTHORS
%exclude %_docdir/%name-%version/COPYING-*
%exclude %_docdir/%name-%version/NEWS
%exclude %_docdir/%name-%version/README

%files tests
%python_sitelibdir/%modulename/test

%files examples
%python_sitelibdir/%modulename/examples

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle

%changelog
