%define major 2.25
%def_enable docs
%def_disable gdl
%def_disable gda
%def_disable gksu2

Name: python-module-pygnome-extras
Version: %major.3
Release: alt4

Summary: Set of extra bindings for the GNOME2 platform library

License: LGPL
Group: Development/Python
Url: http://www.pygtk.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: http://ftp.gnome.org/pub/GNOME/sources/gnome-python-extras/%major/gnome-python-extras-%version.tar.bz2
# GNOME bug #584126
Patch1: gnome-python-extras-2.25.3-update-for-gdl-2.27.2.part1.patch
Patch2: gnome-python-extras-2.25.3-update-for-gdl-2.27.2.part2.patch

%setup_python_module pygnome

%define bname python-module-pygnome

%define python_gnome_dir %python_sitelibdir/gtk-2.0/gnome

%{?_enable_docs:BuildRequires: gtk-doc}
BuildRequires: gcc-c++ glibc-devel libgtkhtml2-devel
BuildRequires: libgtk+2-devel libbonoboui-devel libgnomeui-devel gnome-vfs-devel libgtkspell-devel
BuildRequires: python-module-pygnome-devel xulrunner-devel
# style.css from this package required to build documentation
BuildRequires: python-module-pygobject-devel-doc
BuildPreReq: python-module-pygtk-devel
%{?_enable_gda:BuildPreReq: libgda4-devel >= 3.99.9}
%{?_enable_gdl:BuildRequires: libgdl-devel}
%{?_enable_gksu2:BuildRequires: libgksu-devel}

%description
This package is a set of extra bindings for the Gnome platform
libraries called PyGNOME. It builds on top of the PyGTK bindings for GTK and
the PyORBit bindings for ORBit2.

PyGNOME is an extension module for Python that provides access to the
base GNOME libraries, so you have access to more widgets, a simple
configuration interface, and metadata support.

%package devel
Summary: files needed to build extra wrappers for GNOME libraries
Group: Development/Python
Requires: %name = %version-%release
Requires: python-module-pygnome-devel

%description devel
This package contains files required to build wrappers for GNOME
libraries so that they interoperate with pygnome.

%package devel-doc
Summary: Development documentation for extra wrappers for GNOME libraries
Group: Development/Python
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains development documentation for set of extra
bindings for GNOME libraries.

%package -n %bname-gtkhtml2
Summary: Python bindings for interacting with gtkhtml2
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: gnome-python2-gtkhtml2
Provides: gnome-python2-gtkhtml2

%description -n %bname-gtkhtml2
This module contains a wrapper that allows the use of gtkhtml2 via Python.

%package -n %bname-gda
Summary: Python bindings for interacting with libgda-4
Group: Development/Python
Requires: %name = %version-%release

%description -n %bname-gda
This module contains a wrapper that allows the use of libgda-4 via Python.

%prep
%setup -q -n gnome-python-extras-%version
%patch1 -p1 -b .update-for-gdl-2.27.2.part1
%patch2 -p1 -b .update-for-gdl-2.27.2.part2

%build
%configure --enable-gtkmozembed=off \
	%{subst_enable docs} \
	%{subst_enable gda} \
	%{subst_enable gdl} \
	%{subst_enable gksu2}
%make_build

%install
%makeinstall_std
rm -f %buildroot%python_sitelibdir/gtk-2.0/*.la

%files
%doc AUTHORS ChangeLog README NEWS
%python_sitelibdir/gtk-2.0/egg
%{?_enable_gdl:%python_sitelibdir/gtk-2.0/gdl.so}
%python_sitelibdir/gtk-2.0/gtkspell.so
%{?_enable_gksu2:%python_sitelibdir/gtk-2.0/gksu2/}

%files devel
%{?_enable_gdl:%_includedir/pygda-4.0/pygdavalue_conversions.h}
%_pkgconfigdir/*
%_datadir/pygtk/2.0/defs/*.defs
%doc examples/*

%files devel-doc
%_datadir/gtk-doc/html/*

%files -n %bname-gtkhtml2
%python_sitelibdir/gtk-2.0/gtkhtml*

%if_enabled gda
%files -n %bname-gda
%python_sitelibdir/gtk-2.0/gda*
%_datadir/pygtk/2.0/argtypes/gda*
%endif

%changelog
