%define major 2.28
%define oname pygobject
%define gtk_api_ver 2.0
%def_disable introspection

Name: python-module-pygobject
Version: %major.6
Release: alt3

Summary: Python bindings for GObject

License: LGPL
Group: Development/Python
Url: http://www.pygtk.org/

Source: http://ftp.gnome.org/pub/GNOME/sources/%oname/%major/%oname-%version.tar

%setup_python_module pygobject

%add_python_lib_path  %python_sitelibdir/gtk-%gtk_api_ver
%add_findprov_lib_path %python_sitelibdir/gtk-%gtk_api_ver/gtk
%{?_enable_introspection:%add_findprov_lib_path %python_sitelibdir/gtk-%gtk_api_ver/gi}
%{?_enable_introspection:Requires: python-module-pygi = %version-%release}

Conflicts: python-module-pygtk <= 2.8.2-alt2.1

%define glib_ver 2.28.0

BuildPreReq: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: python-devel python-modules-encodings python-module-pycairo-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.10.2}
# for tests
# BuildRequires: libcairo-gobject-devel dbus-tools-gui libgtk+3-gir-devel

%description
This package provides Python bindings for the GLib, GObject and GIO,
to be used in Python. It is a fairly complete set of bindings,
it's already rather useful, and is usable to write moderately
complex programs.  (see the examples directory for some examples
of the simpler programs you could write).

%package devel
Summary: Development files for %oname
Group: Development/Python
Requires: %name = %version-%release
Conflicts: python-module-pygtk-devel <= 2.8.2-alt2.1

%description devel
Development files for %oname.

%package devel-doc
Summary: Development documentation for %oname
Group: Development/Python
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
Development documentation for %oname.

%package -n python-module-pygi
Summary: Python dynamic bindings based on GObject-Introspection
Group: Development/Python
%{?_enable_introspection:%setup_python_module pygi}
Requires: %name = %version-%release

%description -n python-module-pygi
PyGI is a module which aims to utilize GObject Introspection to
facilitate the creation of Python bindings.

%prep
%setup -q -n %oname-%version

%build
%autoreconf
%configure --with-pic --disable-static \
	%{subst_enable introspection}

%make_build

%check
#%%make check

%install
%make_install install DESTDIR=%buildroot
mkdir -p %buildroot%_includedir/python%__python_version
mv %buildroot%_includedir/pygtk-%gtk_api_ver %buildroot%_includedir/python%__python_version/pygtk
%__subst "s|\${includedir}/pygtk-%gtk_api_ver|\${includedir}/python%__python_version/pygtk|g" %buildroot/%_pkgconfigdir/*.pc

# hack to avoid verify-elf errors
export LD_PRELOAD=%_libdir/libpython%__python_version.so

%files
%_libdir/libpyglib-2.0-python.so.*
%python_sitelibdir/pygtk.*
%python_sitelibdir/gobject
%python_sitelibdir/glib
%dir %python_sitelibdir/gtk-%gtk_api_ver
%python_sitelibdir/gtk-%gtk_api_ver/gio

%files devel
%_bindir/pygobject-codegen-2.0
%_libdir/libpyglib-2.0-python.so
%_includedir/python%__python_version/pygtk
%python_sitelibdir/gtk-%gtk_api_ver/dsextras.*
%_datadir/pygobject/2.0
%_datadir/pygobject/xsl
%_pkgconfigdir/pygobject-2.0.pc
%doc README AUTHORS NEWS examples

%exclude %python_sitelibdir/*/*.la

%files devel-doc
%_datadir/gtk-doc/html/pygobject/

%if_enabled introspection
%files -n python-module-pygi
%python_sitelibdir/gi/
%exclude %python_sitelibdir/gi/*.la
%endif

%changelog
