%define _name pygobject
%define major 3.8
%define api_ver 3.0
%define gtk_api_ver 2.0
%def_disable devel_doc

Name: python-module-%{_name}3
Version: %major.3
Release: alt1

Summary: Python bindings for GObject

License: LGPL
Group: Development/Python
Url: http://www.pygtk.org/

#Source: %_name-%version.tar
Source: http://ftp.gnome.org/pub/GNOME/sources/%_name/%major/%_name-%version.tar.xz

%setup_python_module pygobject3

%add_findprov_lib_path %python_sitelibdir/gi
%add_findprov_lib_path %python_sitelibdir/gtk-%gtk_api_ver

%add_findprov_lib_path %python3_sitelibdir/gi
%add_findprov_lib_path %python3_sitelibdir/gtk-%gtk_api_ver

%add_typelib_req_skiplist typelib(Foo)

%define glib_ver 2.35.3
%define gi_ver 1.35.3

BuildRequires: gnome-common
BuildPreReq: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: python-devel python-modules-encodings python-module-pycairo-devel libcairo-gobject-devel gtk-doc
BuildPreReq: gobject-introspection-devel >= %gi_ver
# python3
BuildRequires: rpm-build-python3 python3-devel python3-module-pycairo-devel
# for tests
BuildRequires: dbus-tools-gui libgtk+3-gir-devel xvfb-run
BuildRequires: glibc-i18ndata

%description
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python
Requires: %name = %version-%release

%description pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package common-devel
Summary: Common development files for %_name
Group: Development/Python

%description common-devel
Common development files for %_name used for both python2 and python3.

%package devel
Summary: Development files for %name
Group: Development/Python
Requires: %name = %version-%release
Requires: %name-common-devel = %version-%release

%description devel
Development files for %name.

%package -n python3-module-%{_name}3
Summary: Python3 bindings for GObject
Group: Development/Python3

%description -n python3-module-%{_name}3
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python3 programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package -n python3-module-%{_name}3-pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python3
Requires: python3-module-%{_name}3 = %version-%release

%description -n python3-module-%{_name}3-pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package -n python3-module-%{_name}3-devel
Summary: Development files for python3-module-%{_name}3
Group: Development/Python3
Requires: python3-module-%{_name}3 = %version-%release
Requires: %name-common-devel = %version-%release

%description -n python3-module-%{_name}3-devel
Development files for python3-module-%{_name}3.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-common-devel < %version-%release

%description devel-doc
Development documentation for %_name.

%prep
%setup -n %_name-%version
%setup -D -c -n %_name-%version
mv %_name-%version py3build

%build
%define opts --with-pic --disable-static --enable-cairo
export PYTHON=%__python
%autoreconf
%configure %opts
%make_build

pushd py3build
export PYTHON=python3
%autoreconf
%configure %opts
%make_build
popd

%install
%makeinstall_std
# hack to avoid verify-elf errors
export LD_PRELOAD=%_libdir/libpython%__python_version.so

pushd py3build
%makeinstall_std
# hack to avoid verify-elf errors
export LD_PRELOAD="${LD_PRELOAD:+"$LD_PRELOAD:"}%_libdir/libpython3.so"
popd

%check
#xvfb-run %make check

# currently fails for python3
#pushd py3build
#xvfb-run %make check
#popd

%files
%_libdir/libpyglib-gi-2.0-python%__python_version.so.*
%python_sitelibdir/gi/
%exclude %python_sitelibdir/gi/pygtkcompat.py*
%python_sitelibdir/*.egg-info/

%exclude %python_sitelibdir/*/*.la

%files pygtkcompat
%python_sitelibdir/pygtkcompat/
%python_sitelibdir/gi/pygtkcompat.py*

%files common-devel
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc
%doc README AUTHORS NEWS examples

%files devel
%_libdir/libpyglib-gi-2.0-python%__python_version.so

%files -n python3-module-%{_name}3
%_libdir/libpyglib-gi-2.0-python3.so.*
%python3_sitelibdir/gi/
%exclude %python3_sitelibdir/gi/pygtkcompat.py*
%python3_sitelibdir/*.egg-info/

%files -n python3-module-%{_name}3-pygtkcompat
%python3_sitelibdir/pygtkcompat/
%python3_sitelibdir/gi/pygtkcompat.py*

%files -n python3-module-%{_name}3-devel
%_libdir/libpyglib-gi-2.0-python3.so

%exclude %python3_sitelibdir/*/*.la

%if_enabled devel_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%changelog
