%define oname pyproj
Name: python-module-%oname
Version: 1.9.3
Release: alt1.svn20130125
Summary: Pyrex generated python interface to PROJ.4 library
License: MIT
Group: Graphics
Url: http://code.google.com/p/pyproj/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# http://pyproj.googlecode.com/svn/trunk
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python
BuildPreReq: libproj-devel python-devel
%setup_python_module %oname

%description
Pyrex generated python interface to PROJ.4 library

Performs cartographic transformations and geodetic computations.

The Proj class can convert from geographic (longitude,latitude) to
native map projection (x,y) coordinates and vice versa, or from one map
projection coordinate system directly to another.

The Geod class can perform forward and inverse geodetic, or Great
Circle, computations. The forward computation involves determining
latitude, longitude and back azimuth of a terminus point given the
latitude and longitude of an initial point, plus azimuth and distance.
The inverse computation involves determining the forward and back
azimuths and distance given the latitudes and longitudes of an initial
and terminus point.

Input coordinates can be given as python arrays, lists/tuples, scalars
or numpy/Numeric/numarray arrays. Optimized for objects that support the
Python buffer protocol (regular python and numpy array objects).

%package tests
Summary: Tests for pyrex generated python interface to PROJ.4 library
Group: Development/Python
Requires: %name = %version-%release

%description tests
Pyrex generated python interface to PROJ.4 library

Performs cartographic transformations and geodetic computations.

This package contains tests for pyrex generated python interface to
PROJ.4 library.

%prep
%setup

%build
%python_build_debug

%install
%python_install

install -d %buildroot%python_sitelibdir/%oname/test
install -p -m644 test/* %buildroot%python_sitelibdir/%oname/test

chmod +x %buildroot%python_sitelibdir/%oname/data/test*

%files
%doc Changelog LICENSE_proj4 README
%python_sitelibdir/*
%exclude %python_sitelibdir/*/test
%exclude %python_sitelibdir/%oname/data/test*

%files tests
%python_sitelibdir/*/test
%python_sitelibdir/%oname/data/test*

%changelog
