%define oname pysparse

%def_enable docs

Name: python-module-%oname
Version: 1.2
Release: alt3.svn20110511
Summary: Fast sparse matrix library for Python
License: MIT
Group: Development/Python
Url: http://pysparse.sourceforge.net/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://pysparse.svn.sourceforge.net/svnroot/pysparse/trunk
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python rpm-macros-sphinx
BuildPreReq: python-devel libnumpy-devel liblapack-devel
BuildPreReq: gcc-c++ gcc-fortran libsuperlu-devel libsuitesparse-devel
BuildPreReq: python-module-sphinx-devel python-module-Pygments
%setup_python_module %oname

%description
Pysparse is a fast sparse matrix library for Python. It provides several
sparse matrix storage formats and conversion methods. It also implements
a number of iterative solvers, preconditioners, and interfaces to
efficient factorization packages. Both low-level and high-level
interfaces are available, each with different strengths.

%if_enabled docs
%package pickles
Summary: Documentation and examples for Pysparse
Group: Development/Documentation

%description pickles
Pysparse is a fast sparse matrix library for Python. It provides several
sparse matrix storage formats and conversion methods. It also implements
a number of iterative solvers, preconditioners, and interfaces to
efficient factorization packages. Both low-level and high-level
interfaces are available, each with different strengths.

This package contains pickles for Pysparse.

%package doc
Summary: Documentation and examples for Pysparse
Group: Development/Documentation
BuildArch: noarch

%description doc
Pysparse is a fast sparse matrix library for Python. It provides several
sparse matrix storage formats and conversion methods. It also implements
a number of iterative solvers, preconditioners, and interfaces to
efficient factorization packages. Both low-level and high-level
interfaces are available, each with different strengths.

This package contains development documentation and examples for
Pysparse.

%endif

%package tests
Summary: Tests for Pysparse
Group: Development/Python
Requires: %name = %version-%release

%description tests
Pysparse is a fast sparse matrix library for Python. It provides several
sparse matrix storage formats and conversion methods. It also implements
a number of iterative solvers, preconditioners, and interfaces to
efficient factorization packages. Both low-level and high-level
interfaces are available, each with different strengths.

This package contains tests for Pysparse.

%if_enabled docs
%prepare_sphinx
%endif

%prep
%setup
sed -i 's|@PYVER@|%_python_version|g' doc/pysparse/Makefile

%build
%python_build_debug

%install
%python_install

%if_enabled docs

%make_build -C doc/pysparse html

install -d %buildroot%_docdir/%oname/test
install -p -m644 doc/*.pdf %buildroot%_docdir/%oname
cp -fR doc/pysparse/build/html \
	%buildroot%_docdir/%oname/
cp -fR examples %buildroot%_docdir/%oname/
cp -fR doc/pysparse/build/pickle \
	%buildroot%python_sitelibdir/%oname/
%endif
cp -fR test %buildroot%python_sitelibdir/%oname/
touch %buildroot%python_sitelibdir/%oname/test/__init__.py

install -d %buildroot%_includedir/python%_python_version/%oname
install -p -m644 %oname/include/* \
	%buildroot%_includedir/python%_python_version/%oname

%files
%doc CHANGES LICENSE README TODO
%python_sitelibdir/*
%if_enabled docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/%oname/test
%_includedir/python%_python_version/%oname

%if_enabled docs
%files doc
%doc %_docdir/%oname

%files pickles
%python_sitelibdir/%oname/pickle
%endif

%files tests
%python_sitelibdir/%oname/test

%changelog
