%define oname pytest

%def_with python3

Name: python-module-%oname
Version: 2.3.5.dev8
Release: alt1.hg20130328
Summary: Simple and popular testing tool for Python
License: MIT
Group: Development/Python
Url: http://pytest.org
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
BuildArch: noarch

# hg clone https://bitbucket.org/hpk42/pytest
Source: %name-%version.tar.gz

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-setuptools
BuildPreReq: python-module-sphinx-devel python-module-py
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

%description
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.

%if_with python3
%package -n python3-module-%oname
Summary: Simple and popular testing tool for Python 3
Group: Development/Python3
%add_python3_req_skip compiler

%description -n python3-module-%oname
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.
%endif

%package docs
Summary: Documentation for py.test
Group: Development/Documentation

%description docs
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.

This package contains documentation for py.test.

%package pickles
Summary: Pickles for py.test
Group: Development/Python

%description pickles
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.

This package contains pickles for py.test.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx doc
ln -s ../objects.inv doc/en/

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
rm -f %buildroot%_bindir/py.test
%endif

%python_install

export PYTHONPATH=%buildroot%python_sitelibdir
pushd doc/en
%make html
%make pickle
popd

install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/en/_build/pickle %buildroot%python_sitelibdir/%oname/

%files
%doc AUTHORS CHANGELOG LICENSE *.txt
%_bindir/*
%exclude %_bindir/py.test-%_python3_version
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle

%files docs
%doc doc/en/_build/html/*

%if_with python3
%files -n python3-module-%oname
%_bindir/py.test-%_python3_version
%python3_sitelibdir/*
%endif

%changelog
