%define oname pytz

%def_with python3

Name: python-module-%oname
Version: 2012j
Release: alt1

%setup_python_module %oname

Summary: World timezone definitions, modern and historical
Source0: %modulename-%version.tar
License: MIT
Group: Development/Python
BuildArch: noarch
Url: http://pytz.sourceforge.net

Packager: Python Development Team <python@packages.altlinux.org>

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

%description
pytz brings the Olson tz database into Python. This library allows
accurate and cross platform timezone calculations using Python 2.3
or higher. It also solves the issue of ambiguous times at the end
of daylight savings, which you can read more about in the Python
Library Reference (datetime.tzinfo).

%if_with python3
%package -n python3-module-%oname
Summary: World timezone definitions, modern and historical (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
pytz brings the Olson tz database into Python. This library allows
accurate and cross platform timezone calculations using Python 2.3
or higher. It also solves the issue of ambiguous times at the end
of daylight savings, which you can read more about in the Python
Library Reference (datetime.tzinfo).

%package -n python3-module-%oname-tests
Summary: Tests for pytz (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
pytz brings the Olson tz database into Python. This library allows
accurate and cross platform timezone calculations using Python 2.3
or higher. It also solves the issue of ambiguous times at the end
of daylight savings, which you can read more about in the Python
Library Reference (datetime.tzinfo).

This package contains tests for pytz.
%endif

%package tests
Summary: Tests for pytz
Group: Development/Python
Requires: %name = %version-%release

%description tests
pytz brings the Olson tz database into Python. This library allows
accurate and cross platform timezone calculations using Python 2.3
or higher. It also solves the issue of ambiguous times at the end
of daylight savings, which you can read more about in the Python
Library Reference (datetime.tzinfo).

This package contains tests for pytz.

%prep
%setup -n %modulename-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install --optimize=2 --record=INSTALLED_FILES
install -d %buildroot%python_sitelibdir/%modulename/tests
install -p -m644 %modulename/tests/* \
	%buildroot%python_sitelibdir/%modulename/tests
touch %buildroot%python_sitelibdir/%modulename/tests/__init__.py

%if_with python3
pushd ../python3
%python3_install
install -d %buildroot%python3_sitelibdir/%oname/tests
install -p -m644 %oname/tests/* \
	%buildroot%python3_sitelibdir/%oname/tests
touch %buildroot%python3_sitelibdir/%oname/tests/__init__.py
popd
%endif

%files -f INSTALLED_FILES
%python_sitelibdir/%modulename
%exclude %python_sitelibdir/%modulename/tests
%doc *.txt

%files tests
%python_sitelibdir/%modulename/tests

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests

#files -n python3-module-%oname-tests
#python3_sitelibdir/%oname/tests
%endif

%changelog
