%define pkgname requests
%def_with python3

Name:           python-module-requests
Version:        2.3.0
Release:        alt1
Summary:        HTTP library, written in Python, for human beings
Group:          Development/Python

License:        ASL 2.0
URL:            http://pypi.python.org/pypi/requests
Source0:        %{name}-%{version}.tar
# Explicitly use the system certificates in ca-certificates.
# https://bugzilla.redhat.com/show_bug.cgi?id=904614
Patch0:         python-requests-system-cert-bundle.patch
# Unbundle python-charade (a fork of python-chardet).
# https://bugzilla.redhat.com/show_bug.cgi?id=904623
Patch1:         python-requests-system-chardet-not-charade.patch
# Unbundle python-urllib3 (a fork of python-urllib3).
# https://bugzilla.redhat.com/show_bug.cgi?id=904623
Patch2:         python-requests-system-urllib3.patch

BuildArch:      noarch
BuildRequires:  python-devel python-modules-json
BuildRequires:  python-module-chardet
BuildRequires:  python-module-urllib3 >= 1.8.2
BuildRequires:  python-module-ordereddict

Requires:       ca-certificates
Requires:       python-module-chardet
Requires:       python-module-urllib3 >= 1.8.2
Requires:       python-module-ordereddict

%description
Most existing Python modules for sending HTTP requests are extremely verbose and 
cumbersome. Python's built-in urllib2 module provides most of the HTTP 
capabilities you should need, but the API is thoroughly broken. This library is 
designed to make HTTP requests easy for developers.

%if_with python3
%package -n python3-module-%pkgname
Summary: HTTP library, written in Python, for human beings
Group:   Development/Python3
BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-devel python3-base
BuildRequires:  python3-module-chardet
BuildRequires:  python3-module-urllib3 >= 1.8.2
Requires:       python3-module-chardet
Requires:       python3-module-urllib3 >= 1.8.2

%description -n python3-module-%pkgname
Most existing Python modules for sending HTTP requests are extremely verbose and
cumbersome. Python's built-in urllib2 module provides most of the HTTP
capabilities you should need, but the API is thoroughly broken. This library is
designed to make HTTP requests easy for developers.
%endif

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1

# Unbundle the certificate bundle from mozilla.
rm -rf requests/cacert.pem

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build

# Unbundle chardet.  Patch1 switches usage to system chardet.
# Unbundle urllib3.  Patch2 switches usage to system urllib3.
rm -rf build/lib/requests/packages

%if_with python3
pushd ../python3
%python3_build

# Unbundle chardet.  Patch1 switches usage to system chardet.
# Unbundle urllib3.  Patch2 switches usage to system urllib3.
rm -rf build/lib/requests/packages

popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif


## The tests succeed if run locally, but fail in koji.
## They require an active network connection to query httpbin.org
#%%check
#%%{__python} test_requests.py
#%%if 0%%{?_with_python3}
#pushd %%{py3dir}
#%%{__python3} test_requests.py
#popd
#%%endif

%files
%doc NOTICE LICENSE README.rst HISTORY.rst
%python_sitelibdir/%pkgname
%python_sitelibdir/*.egg-info

%if_with python3
%files -n python3-module-%pkgname
%doc NOTICE LICENSE README.rst HISTORY.rst
%python3_sitelibdir/%pkgname
%python3_sitelibdir/*.egg-info
%endif

%changelog
