%define rhome %_libdir/R
%define oname rpy

%def_enable docs

Name: python-module-%oname
Version: 1.0.3
Release: alt4.M70P.1.svn20101101.1
Summary: Python interface to the R Programming Language
License: MPL/GPL/LGPL
Group: Development/Python
Url: http://rpy.sourceforge.net/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://rpy.svn.sourceforge.net/svnroot/rpy/trunk
Source: %oname-%version.tar.gz
Source1: http://rpy.sourceforge.net/faithful.py
Patch1:	 R-3.0.0-compat.patch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel 
BuildPreReq: R-devel > 3.0.0
BuildPreReq: python-module-sphinx-devel
BuildPreReq: python-module-Pygments
%setup_python_module %oname

%description
RPy is a very simple, yet robust, Python interface to the R Programming
Language. It can manage all kinds of R objects and can execute arbitrary
R functions (including the graphic functions). All errors from the R
language are converted to Python exceptions. Any module installed for
the R system can be used from within Python.

This code is inspired by RSPython from the Omegahat project. The main
goals of RPy are:

  * to have a very robust interface for using R from Python

  * the interface should be as transparent and easy to use as possible

  * it should be usable for real scientific and statistical computations

%if_enabled docs

%package pickles
Summary: Pickles for RPy
Group: Development/Python

%description pickles
RPy is a very simple, yet robust, Python interface to the R Programming
Language. It can manage all kinds of R objects and can execute arbitrary
R functions (including the graphic functions). All errors from the R
language are converted to Python exceptions. Any module installed for
the R system can be used from within Python.

This package contains pickles for RPy.

%package doc
Summary: Documentation and examples for RPy
Group: Development/Documentation
BuildArch: noarch

%description doc
RPy is a very simple, yet robust, Python interface to the R Programming
Language. It can manage all kinds of R objects and can execute arbitrary
R functions (including the graphic functions). All errors from the R
language are converted to Python exceptions. Any module installed for
the R system can be used from within Python.

This package contains development documentation and examples for RPy.

%endif

%prep
%setup
%patch1 -p2
cp -f %SOURCE1 examples/

%if_enabled docs
%prepare_sphinx .
%endif

%build
find -type f -print0 |
	xargs -r0 grep -FlZ runtime_library_dirs -- |
	xargs -r0 sed -i /runtime_library_dirs/d --
export RHOME=%rhome
%python_build_debug

%if_enabled docs
pushd doc
%make_build info html
popd

%generate_pickles $PWD $PWD/doc/rpy_html %oname
%endif

%install
export RHOME=%_libdir/R
%python_install

install -d %buildroot%_docdir/%oname
install -d %buildroot%_infodir

%if_enabled docs
install -m644 doc/rpy_html/* %buildroot%_docdir/%oname
cp -fR examples %buildroot%_docdir/%oname/
install -m644 doc/*.info %buildroot%_infodir

install -d %buildroot%python_sitelibdir/%oname
cp -fR pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc NEWS README TODO GPL_LICENSE LGPL_LICENSE MPL_LICENSE
%python_sitelibdir/*
%if_enabled docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/rpy_wintools*

%if_enabled docs
%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle

%files doc
%_docdir/%oname
%_infodir/*
%endif

%changelog
