# Note: mkl is a Intel Compiler thing

BuildRequires(pre): rpm-build-python
%define python_noarch %python_sitelibdir_noarch

%define oname scipy
%define svnver 8cec719

%def_enable docs
%def_with python3

Name: python-module-%oname
Version: 0.12.0
Release: alt2.git20121009.1

Summary: SciPy is the library of scientific codes

License: BSD
Group: Development/Python
Url: http://www.scipy.org/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%setup_python_module %oname
Requires: %python_noarch

#add_python_req_skip swig2_ext symeig vtk

# git://github.com/scipy/scipy.git
Source: %oname-%version.tar
Source1: site.cfg

BuildPreReq: python-module-sympy python-module-scipy
BuildPreReq: python-module-numpy python-module-matplotlib
BuildPreReq: python-module-numdifftools
BuildPreReq: libsuitesparse-devel swig /proc rpm-macros-make
BuildPreReq: python-module-sphinx-devel
BuildPreReq: python-module-Pygments
BuildPreReq: python-module-matplotlib
%if_enabled docs
BuildPreReq: python-module-matplotlib-sphinxext
BuildPreReq: %py_dependencies scikits.statsmodels.docs.sphinxext
%endif

BuildRequires: gcc-c++ gcc-fortran liblapack-devel python-module-Pyrex
BuildRequires: python-module-ctypes libnumpy-devel python-modules-curses
BuildRequires: libsuitesparse-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-Pygments libnumpy-py3-devel
BuildPreReq: python-tools-2to3
%endif


%description
SciPy is the library of scientific codes built on top of NumPy.

%if_with python3
%package -n python3-module-%oname
Summary: SciPy is the library of scientific codes (Python 3)
Group: Development/Python3
Requires: %python3_sitelibdir_noarch
%add_python3_req_skip _min_spanning_tree _shortest_path _tools
%add_python3_req_skip _traversal

%description -n python3-module-%oname
SciPy is the library of scientific codes built on top of NumPy.

%package -n python3-module-%oname-devel
Summary: Development files of SciPy (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
Requires: python3-devel libnumpy-py3-devel

%description -n python3-module-%oname-devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%package -n python3-module-%oname-tests
Summary: Tests and examples for SciPy (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%add_python3_req_skip ext_tools inline_tools swig2_ext symeig
%add_python3_req_skip md5 vtk wxPython
%add_python3_req_skip pylab

%description -n python3-module-%oname-tests
SciPy is the library of scientific codes built on top of NumPy.

This package contains tests and examples for SciPy.

%package -n python3-module-weave
Summary: Weave provides tools for including C/C++ code within Python 3
Group: Development/Python3
BuildArch: noarch

%description -n python3-module-weave
Weave provides tools for including C/C++ code within Python 3.

%package -n python3-module-weave-tests
Summary: Tests for Weave (Python 3)
Group: Development/Python3
Requires: python3-module-weave = %version-%release
BuildArch: noarch

%description -n python3-module-weave-tests
Weave provides tools for including C/C++ code within Python 3.

This package contains tests for Weave.
%endif

%package devel
Summary: Development files of SciPy
Group: Development/Python
Requires: %name = %version-%release
Requires: python-devel libnumpy-devel

%description devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%package tests
Summary: Tests and examples for SciPy
Group: Development/Python
Requires: %name = %version-%release
%add_python_req_skip ext_tools inline_tools swig2_ext symeig vtk

%description tests
SciPy is the library of scientific codes built on top of NumPy.

This package contains tests and examples for SciPy.

%if_enabled docs
%package pickles
Summary: Pickles for SciPy
Group: Development/Python

%description pickles
SciPy is the library of scientific codes built on top of NumPy.

This package contains pickles for SciPy.

%package doc-html
Summary: Documentation for SciPy in HTML
Group: Development/Documentation
BuildArch: noarch

%description doc-html
SciPy is the library of scientific codes built on top of NumPy.

This package contains development documentation for SciPy in HTML.

%package doc-pdf
Summary: Documentation for SciPy in PDF
Group: Development/Documentation

%description doc-pdf
SciPy is the library of scientific codes built on top of NumPy.

This package contains development documentation for SciPy in PDF.

%endif

%package -n python-module-weave
Summary: Weave provides tools for including C/C++ code within Python
Group: Development/Python
BuildArch: noarch

%description -n python-module-weave
Weave provides tools for including C/C++ code within Python.

%package -n python-module-weave-tests
Summary: Tests for Weave
Group: Development/Python
Requires: python-module-weave = %version-%release
BuildArch: noarch

%description -n python-module-weave-tests
Weave provides tools for including C/C++ code within Python 3.

This package contains tests for Weave.

%prep
%setup
install -p -m644 %SOURCE1 .
sed -i 's|@LIBDIR@|%_libdir|g' site.cfg doc/Makefile
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile

cat <<EOF >%oname/__svn_version__.py
version='%version'
svn_version='%svnver'
EOF

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

# Sphinx
%if_enabled docs
sed -i "s|@TOP@|$PWD|" \
	doc/source/conf.py
sed -i 's|@SPHINXREL@|%sphinx_rel|' \
	doc/source/conf.py
%prepare_sphinx .
cp conf.py objects.inv doc/
%endif

mkdir -p ~/.matplotlib
cp %python_sitelibdir/matplotlib/mpl-data/matplotlibrc \
	~/.matplotlib/
sed -i 's|^\(backend\).*|\1 : Agg|' ~/.matplotlib/matplotlibrc

%build
%add_optflags -I%_includedir/suitesparse -fno-strict-aliasing %optflags_shared
%python_build_debug build_ext build_py build_clib \
	config_fc --fcompiler=gnu95

# weave

pushd scipy/weave
%python_build_debug build_ext build_py build_clib build_scripts \
	config_fc --fcompiler=gnu95
popd

%if_with python3
pushd ../python3
%python3_build_debug build_ext build_py build_clib \
	config_fc --fcompiler=gnu95

# weave

pushd scipy/weave
%python3_build_debug build_ext build_py build_clib build_scripts \
	config_fc --fcompiler=gnu95
popd

popd
%endif

%install
%python_install install_lib install_headers \
	install_data config_fc
pushd scipy/weave
%python_install install_lib install_headers \
	install_data config_fc
popd

install -m644 %oname/__svn_version__.py \
	%buildroot%python_sitelibdir/%oname

# headers

pushd %oname
for i in $(find ./ -name '*.h' |grep -v weave); do
	dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
	install -d %buildroot%_includedir/%oname/$dir
	install -p -m644 $i \
		%buildroot%_includedir/%oname/$dir
done
popd
pushd %buildroot%python_noarch/weave
for i in $(find ./ -name '*.h'); do
	dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
	install -d %buildroot%_includedir/weave/$dir
	ln -s %python_noarch/weave/$i \
		%buildroot%_includedir/weave/$dir
done
popd
install -p -m644 $(find ./ -name fortranobject.h) \
	%buildroot%_includedir/%oname

%if_with python3
pushd ../python3
sed -i \
	's|from UserDict import UserDict|from collections import UserDict|' \
	scipy/weave/tests/test_scxx_object.py

%python3_install install_lib install_headers \
	install_data config_fc
pushd scipy/weave
%python3_install install_lib install_headers \
	install_data config_fc
popd

install -m644 %oname/__svn_version__.py \
	%buildroot%python3_sitelibdir/%oname

# headers

pushd %oname
for i in $(find ./ -name '*.h' |grep -v weave); do
	dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
	install -d %buildroot%_includedir/%oname-py3/$dir
	install -p -m644 $i \
		%buildroot%_includedir/%oname-py3/$dir
done
popd
pushd %buildroot%python3_sitelibdir_noarch/weave
for i in $(find ./ -name '*.h'); do
	dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
	install -d %buildroot%_includedir/weave-py3/$dir
	ln -s %python3_sitelibdir_noarch/weave/$i \
		%buildroot%_includedir/weave-py3/$dir
done
for i in $(find ./ -name '*.py'); do
	2to3 -w -n $i
done
popd
install -p -m644 $(find ./ -name fortranobject.h) \
	%buildroot%_includedir/%oname-py3
popd
pushd %buildroot%python3_sitelibdir/%oname/sparse/csgraph
for i in $(ls *.so); do
	ln -s %python3_sitelibdir/%oname/sparse/csgraph/$i \
		%buildroot%python3_sitelibdir/
done
popd
%endif

# docs
%if_enabled docs
export PYTHONPATH=%buildroot%python_sitelibdir
%add_optflags -I%buildroot%_includedir -I%_includedir/suitesparse
PATH=$PATH:%python_sitelibdir/scikits/statsmodels/docs/sphinxext
export PATH=$PATH:%python_sitelibdir/scikits/statsmodels/docs
pushd doc
%make_ext default
popd

install -d %buildroot%_docdir/%name
cp -fR doc/build/html %buildroot%_docdir/%name/
#cp -u $(find doc -name '*.pdf' |egrep -v plot_directive) \
#	%buildroot%_docdir/%name/pdf/
#install -p -m644 doc/build/plot_directive/tutorial/*.pdf \
#	%buildroot%_docdir/%name/pdf/tutorial
install -p -m644 LICENSE.txt README.txt THANKS.txt TOCHANGE.txt LATEST.txt \
	%buildroot%_docdir/%name/

# pickles

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/
%endif
# tests

for i in $(find ./ -name tests -type d) \
	$(find ./ -name examples -type d)
do
	touch $i/__init__.py
done

%find_lang %name

#check
#pushd %buildroot%python_sitelibdir
#python -c "import scipy ; scipy.test()"
#popd
#rm -f %buildroot%python_sitelibdir/*.so \
#	%buildroot%python_sitelibdir/*.cpp

%files -f %name.lang
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/*/examples
%exclude %python_sitelibdir/%oname/*/tests
%exclude %python_sitelibdir/%oname/*/*/tests
%exclude %python_sitelibdir/%oname/*/*/*/tests
%exclude %python_sitelibdir/%oname/*/*/*/*/tests
%if_enabled docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/%oname/weave/blitz
%exclude %python_noarch/weave
%exclude %python_noarch/weave-*.egg-info

%files tests
%python_sitelibdir/%oname/*/examples
%python_sitelibdir/%oname/*/tests
%python_sitelibdir/%oname/*/*/tests
%python_sitelibdir/%oname/*/*/*/tests
%python_sitelibdir/%oname/*/*/*/*/tests

%files devel
%_includedir/*
%if_with python3
%exclude %_includedir/%oname-py3
%exclude %_includedir/weave-py3
%endif
%python_sitelibdir/%oname/weave/blitz

%if_with python3
%files -n python3-module-%oname -f %name.lang
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/*/examples
%exclude %python3_sitelibdir/%oname/*/tests
%exclude %python3_sitelibdir/%oname/*/*/tests
%exclude %python3_sitelibdir/%oname/*/*/*/tests
%exclude %python3_sitelibdir/%oname/*/*/*/*/tests
%exclude %python3_sitelibdir/%oname/weave/blitz
%exclude %python3_sitelibdir_noarch/weave
%exclude %python3_sitelibdir_noarch/weave-*.egg-info

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/*/examples
%python3_sitelibdir/%oname/*/tests
%python3_sitelibdir/%oname/*/*/tests
%python3_sitelibdir/%oname/*/*/*/tests
%python3_sitelibdir/%oname/*/*/*/*/tests

%files -n python3-module-%oname-devel
%_includedir/%oname-py3
%_includedir/weave-py3
%python3_sitelibdir/%oname/weave/blitz
%endif

%if_enabled docs
%files doc-html
%dir %_docdir/%name
%_docdir/%name/html

#files doc-pdf
#dir %_docdir/%name
#_docdir/%name/pdf

%files pickles
%python_sitelibdir/%oname/pickle
%endif

%_python_set_noarch
%files -n python-module-weave
%doc scipy/weave/LICENSE.txt scipy/weave/README.txt
%python_noarch/weave*
%exclude %python_noarch/weave/examples
%exclude %python_noarch/weave/tests

%files -n python-module-weave-tests
%python_noarch/weave/examples
%python_noarch/weave/tests

%if_with python3
%files -n python3-module-weave
%doc scipy/weave/LICENSE.txt scipy/weave/README.txt
%python3_sitelibdir_noarch/weave*
%exclude %python3_sitelibdir_noarch/weave/examples
%exclude %python3_sitelibdir_noarch/weave/tests

%files -n python3-module-weave-tests
%python3_sitelibdir_noarch/weave/examples
%python3_sitelibdir_noarch/weave/tests
%endif

%changelog
