%define modulename setuptools

%def_with python3

Name: python-module-%modulename
Epoch: 1
Version: 5.4.1
Release: alt1

Summary: Python Distutils Enhancements
License: PSF/ZPL
Group: Development/Python
URL: http://pypi.python.org/pypi/setuptools

Source0: %modulename.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel

Provides: python-module-distribute = %epoch:%version-%release

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
%endif

%description
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.

%package tests
Summary: Tests for Setuptools
Group: Development/Python
Requires: %name = %EVR

%description tests
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.

This package contains tests for Setuptools.

%package docs
Summary: Documentation for Setuptools
Group: Development/Documentation
Provides: python-module-distribute-docs = %epoch:%version-%release

%description docs
Distribute is intended to replace Setuptools as the standard method for
working with Python module distributions.

This package contains documentation for Distribute.

%if_with python3
%package -n python3-module-%modulename
Summary: Python Distutils Enhancements
Group: Development/Python3
Provides: python3-module-distribute = %epoch:%version-%release

%description -n python3-module-%modulename
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.

%package  -n python3-module-%modulename-tests
Summary: Tests for Setuptools
Group: Development/Python3
Requires: python3-module-%modulename = %EVR

%description  -n python3-module-%modulename-tests
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.

This package contains tests for Setuptools.
%endif

%prep
%setup -n %modulename

#mv "setuptools/script template.py" \
#	setuptools/script_template.py
#mv "setuptools/script template (dev).py" \
#	"setuptools/script_template_(dev).py"

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
#python setup.py test

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
mkdir -p %buildroot%python_sitelibdir
%python_install --optimize=2 --record=INSTALLED_FILES

%if_with python3
pushd ../python3
%python3_install
popd
%endif

rm -f %buildroot%_bindir/easy_install
ln -s easy_install-%_python_version %buildroot%_bindir/easy_install
%if_with python3
ln -s easy_install-%_python3_version %buildroot%_bindir/easy_install3
%endif

%files
%doc *.txt
%_bindir/easy_install
%_bindir/easy_install-%_python_version
%python_sitelibdir/*
%exclude %python_sitelibdir/%modulename/command/test.py*
%exclude %python_sitelibdir/%modulename/tests

%files tests
%python_sitelibdir/%modulename/command/test.py*
%python_sitelibdir/%modulename/tests

%files docs
%doc docs/*.txt

%if_with python3
%files -n python3-module-%modulename
%_bindir/easy_install3
%_bindir/easy_install-%_python3_version
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%modulename/command/test.py*
%exclude %python3_sitelibdir/%modulename/tests

%files -n python3-module-%modulename-tests
%python3_sitelibdir/%modulename/command/test.py*
%python3_sitelibdir/%modulename/tests
%endif

%changelog
