%define oname sphinx

%def_with python3

Name: python-module-%oname
Version: 1.3
Release: alt0.M70P.1
Epoch: 1

Summary: Tool for producing documentation for Python projects
License: BSD
Group: Development/Python
Url: http://sphinx.pocoo.org/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source0: %name-%version.tar
Source1: conf.py.template
Source2: macro
Source3: macro3
Source4: refcounting.py

BuildArch: noarch

BuildRequires(pre): python-module-objects.inv
BuildPreReq: python-devel python-module-setuptools python-module-simplejson
# for docs
#BuildPreReq: texlive-latex-extra 
BuildPreReq: python-module-Pygments
BuildPreReq: python-module-docutils python-module-jinja2 texlive-latex-base
# for tests
BuildPreReq: python-module-nose python-modules-json
BuildPreReq: python-module-snowballstemmer
BuildRequires: python-module-six
%if_with python3
BuildRequires(pre): rpm-build-python3 python3-module-objects.inv
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-Pygments python3-module-docutils
BuildPreReq: python3-module-jinja2 python3-module-nose
BuildPreReq: python-tools-2to3 python3-module-jinja2-tests
BuildPreReq: python3-module-snowballstemmer
%endif

%py_requires simplejson

%description
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%if_with python3
%package -n python3-module-%oname
Summary: Tool for producing documentation for Python 3 projects
Group: Development/Python3
%add_python3_req_skip xapian

%description -n python3-module-%oname
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%package -n python3-module-%oname-devel
Summary: Development package for Sphinx (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %epoch:%version-%release
#Requires: python3-module-%oname-pickles = %epoch:%version-%release
Requires: python3-module-%oname-tests
PreReq: rpm-macros-%{oname}3 >= %epoch:%version-%release
Requires: python3-module-objects.inv
Requires: python3-module-jinja2-tests

%description -n python3-module-%oname-devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package -n python3-module-%oname-pickles
Summary: Pickles for Sphinx (Python 3)
Group: Development/Python3

%description -n python3-module-%oname-pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.

%package -n python3-module-%oname-tests
Summary: Tests for Sphinx (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %epoch:%version-%release
%py3_requires nose
%add_python3_req_skip compiler
%add_python3_req_skip missing_module missing_package1 missing_package2
%add_python3_req_skip missing_package3

%description -n python3-module-%oname-tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%package -n rpm-macros-%{oname}3
Summary: RPM macros for build with Sphinx (Python 3)
Group: Development/Python3
Requires: rpm-build-python3 python3-module-objects.inv
Requires: python3-module-%oname = %epoch:%version-%release

%description -n rpm-macros-%{oname}3
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.
%endif

%package devel
Summary: Development package for Sphinx
Group: Development/Python
Requires: %name = %epoch:%version-%release
Requires: %name-pickles = %epoch:%version-%release
PreReq: rpm-macros-%oname >= %epoch:%version-%release
Requires: python-module-objects.inv

%description devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package -n rpm-macros-%oname
Summary: RPM macros for build with Sphinx
Group: Development/Python
Requires: rpm-build-python python-module-objects.inv
Requires: %name = %epoch:%version-%release

%description -n rpm-macros-%oname
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.

%package tests
Summary: Tests for Sphinx
Group: Development/Python
Requires: %name = %epoch:%version-%release
%py_requires nose
%add_python_req_skip compiler
%add_python_req_skip missing_module missing_package1 missing_package2
%add_python_req_skip missing_package3

%description tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%package doc
Summary: Documentation for Sphinx
Group: Development/Python

%description doc
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package contains documentation for Sphinx itself.

%package pickles
Summary: Pickles for Sphinx
Group: Development/Python

%description pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.

%prep
%setup

cp %SOURCE4 sphinx/ext/

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

install -p -m644 %SOURCE1 %SOURCE2 .
install -p -m644 %SOURCE1 %SOURCE3 ../python3

install -p -m644 %python_sitelibdir/%oname/objects.inv doc
install -p -m644 %python_sitelibdir/%oname/objects.inv tests

%if_with python3
install -p -m644 %python3_sitelibdir/%oname/objects.inv ../python3/doc
install -p -m644 %python3_sitelibdir/%oname/objects.inv ../python3/tests
%endif

%build
%python_build

%if_with python3
pushd ../python3

find -type f -name '*.py' -exec 2to3 -w -n '{}' +
sed -i 's|python|python3|' doc/Makefile
sed -i 's|mimetools|email|g' tests/etree13/HTMLTreeBuilder.py
sed -i 's|%_bindir/python|%_bindir/python3|' tests/coverage.py
sed -i 's|%_bindir/env python|%_bindir/env python3|' \
	tests/path.py tests/run.py

#cp -fR tests %oname/
#for i in $(find %oname/tests -type d)
#do
#	touch $i/__init__.py
#done

%python3_build

popd
%endif

# docs

%make_build -C doc html
%make_build -C doc man

%install
%if_with python3
pushd ../python3
%python3_install

cp -fR tests %buildroot%python3_sitelibdir/%oname/
for i in $(find %buildroot%python3_sitelibdir/%oname/tests -type d)
do
	touch $i/__init__.py
done

popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd
%endif

%python_install

# tests

cp -fR tests %buildroot%python_sitelibdir/%oname/
for i in $(find %buildroot%python_sitelibdir/%oname/tests -type d)
do
	touch $i/__init__.py
done

# docs

install -d %buildroot%_docdir/%name
#install -d %buildroot%_docdir/%name/pdf
install -d %buildroot%_man1dir

cp -fR doc/_build/html %buildroot%_docdir/%name/
#install -p -m644 doc/_build/latex/*.pdf %buildroot%_docdir/%name/pdf
install -p -m644 AUTHORS CHANGES EXAMPLES LICENSE README.rst TODO \
	%buildroot%_docdir/%name
#install -p -m644 doc/_build/man/*.1 %buildroot%_man1dir

# macros

install -d %buildroot%_rpmmacrosdir
install -p -m644 macro %buildroot%_rpmmacrosdir/%oname
install -p -m644 ../python3/macro3 %buildroot%_rpmmacrosdir/%{oname}3

#install -p -m644 %oname/directives/desc.py \
#	%buildroot%python_sitelibdir/%oname/directives/

#if_with python3
#install -p -m644 %oname/directives/desc.py \
#	%buildroot%python3_sitelibdir/%oname/directives/
#endif

# add pickle files

%make_build -C doc pickle

install -d %buildroot%python_sitelibdir/%oname/doctrees
install -p -m644 doc/_build/doctrees/*.pickle \
	%buildroot%python_sitelibdir/%oname/doctrees/
install -p -m644 %oname/pycode/*.pickle \
	%buildroot%python_sitelibdir/%oname/pycode/
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
install -p -m644 conf.py.template \
	%buildroot%python_sitelibdir/%oname/

%ifarch x86_64
LIBSUF=64
%endif

#if_with python3
#pushd ../python3
#export PYTHONPATH=%buildroot%python3_sitelibdir
#export PATH=$PATH:%buildroot%_bindir
#sed -i 's|^SPHINXBUILD.*|SPHINXBUILD = py3_sphinx-build|' doc/Makefile
#make_build -C doc pickle
#install -d %buildroot%python3_sitelibdir/%oname/doctrees
#install -p -m644 doc/_build/doctrees/*.pickle \
#	%buildroot%python3_sitelibdir/%oname/doctrees/
#cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/
install -p -m644 conf.py.template \
	%buildroot%python3_sitelibdir/%oname/
#popd
#endif

#check
# test_autosummary work only with installed Sphinx
#rm -f tests/test_autosummary.py
#make test

%files
%_bindir/*
%exclude %_bindir/py3_*
%python_sitelibdir/%oname/
%exclude %python_sitelibdir/%oname/tests
%exclude %python_sitelibdir/%oname/pickle
%exclude %python_sitelibdir/%oname/doctrees
%python_sitelibdir/*.egg-info
#_man1dir/*

%files devel

%files pickles
%python_sitelibdir/%oname/pickle
%python_sitelibdir/%oname/doctrees

%files tests
%python_sitelibdir/%oname/tests
%python_sitelibdir/%oname/tests

%files doc
%doc %_docdir/%name

%files -n rpm-macros-%oname
%_rpmmacrosdir/%oname

%if_with python3
%files -n python3-module-%oname
%_bindir/py3_*
%python3_sitelibdir/%oname/
%exclude %python3_sitelibdir/%oname/tests
#exclude %python3_sitelibdir/%oname/pickle
#exclude %python3_sitelibdir/%oname/doctrees
%python3_sitelibdir/*.egg-info

%files -n python3-module-%oname-devel

#files -n python3-module-%oname-pickles
#python3_sitelibdir/%oname/pickle
#python3_sitelibdir/%oname/doctrees

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests

%files -n rpm-macros-%{oname}3
%_rpmmacrosdir/%{oname}3
%endif

%changelog
