%define oname TTFQuery
Name: python-module-ttfquery
Version: 1.0.1
Release: alt2.1.1

Summary: FontTools-based package for querying system fonts

Group: Development/Python
License: BSD-like
Url: http://ttfquery.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://downloads.sourceforge.net/ttfquery/%oname-%version.tar.gz

BuildArch: noarch

%setup_python_module %oname

BuildPreReq: rpm-build-compat >= 1.2

BuildRequires: python-devel python-module-setuptools python-module-fonttools

%description
TTFQuery builds on the FontTools package to allow the Python programmer
to accomplish a number of tasks:

  * query the system to find installed fonts
  * retrieve metadata about any TTF font file (even those not yet
    installed)
      o abstract family type
      o proper font name
      o glyph outlines
  * build simple metadata registries for run-time font matching

With these functionalities, it is possible to readily
create OpenGL solid-text rendering libraries which
can accept abstract font-family names as font specifiers
and deliver platform-specific TTF files to match those libraries.

TTFQuery doesn't provide rendering services, but a sample
implementation can be found in the OpenGLContext project, from
which TTFQuery was refactored.

%prep
%setup -n %oname-%version

%build
%python_build

%install
%python_install

%files
%doc license.txt
%python_sitelibdir/ttfquery/
%python_sitelibdir/*egg-info/

%changelog
