%define origname ufc

Name:           python-module-%origname
Version:        2.1.0
Release:        alt2.bzr20130129
Summary:        Unified Form-assembly Code
Group:          Development/Python
License:        Public domain
URL:            http://www.fenics.org/ufc/
# bzr branch lp:ufc
Source:        %origname-%version.tar.gz
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel swig boost-devel gcc-c++ cmake
%setup_python_module ufc

%description
UFC (Unified Form-assembly Code) is a unified framework for finite
element assembly. More precisely, it defines a fixed interface for
communicating low level routines (functions) for evaluating and
assembling finite element variational forms. The UFC interface
consists of a single header file ufc.h that specifies a C++ interface
that must be implemented by code that complies with the UFC
specification. Examples of form compilers that support the UFC
interface are FFC and SyFi.

%package -n %origname-devel
Summary: Development files for UFC
Group: Development/Other
Requires: %name = %version-%release

%description -n %origname-devel
UFC (Unified Form-assembly Code) is a unified framework for finite
element assembly. More precisely, it defines a fixed interface for
communicating low level routines (functions) for evaluating and
assembling finite element variational forms. The UFC interface
consists of a single header file ufc.h that specifies a C++ interface
that must be implemented by code that complies with the UFC
specification. Examples of form compilers that support the UFC
interface are FFC and SyFi.

This package contains development files for UFC.

%package -n %origname-manual
Summary: User manual for UFC
Group: Development/Documentation
BuildArch: noarch

%description -n %origname-manual
UFC (Unified Form-assembly Code) is a unified framework for finite
element assembly. More precisely, it defines a fixed interface for
communicating low level routines (functions) for evaluating and
assembling finite element variational forms. The UFC interface
consists of a single header file ufc.h that specifies a C++ interface
that must be implemented by code that complies with the UFC
specification. Examples of form compilers that support the UFC
interface are FFC and SyFi.

This package contains user manual for developers.

%package -n python-module-ufc_utils
Summary: Code generation format strings for UFC
Group: Development/Python
BuildArch: noarch

%description -n python-module-ufc_utils
UFC (Unified Form-assembly Code) is a unified framework for finite
element assembly. More precisely, it defines a fixed interface for
communicating low level routines (functions) for evaluating and
assembling finite element variational forms. The UFC interface
consists of a single header file ufc.h that specifies a C++ interface
that must be implemented by code that complies with the UFC
specification. Examples of form compilers that support the UFC
interface are FFC and SyFi.

This package contains code generation format strings for UFC.

%prep
%setup

%build
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_C_FLAGS:STRING="%optflags %optflags_shared" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags %optflags_shared" \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_STRIP:FILEPATH=/bin/echo \
	.
%make_build

#pushd src/utils/python/ufc_benchmark
#export CC=g++
#python_build_debug
#popd

%install
%makeinstall_std

#pushd src/utils/python/ufc_benchmark
#python_install
#popd

%ifarch x86_64
install -d %buildroot%_pkgconfigdir
mv %buildroot%_libexecdir/pkgconfig/* %buildroot%_pkgconfigdir/
rmdir %buildroot%_libexecdir/pkgconfig
%endif

sed -i 's|%buildroot||' %buildroot%_pkgconfigdir/ufc-1.pc
sed -i 's|^\(Version\).*|\1: %version|' %buildroot%_pkgconfigdir/ufc-1.pc

install -d %buildroot%_docdir/%origname
install -p -m644 doc/manual/ufc-user-manual.pdf %buildroot%_docdir/%origname

%files
%doc AUTHORS ChangeLog README TODO
%python_sitelibdir/*

%files -n %origname-devel
%_includedir/*
%_pkgconfigdir/*
%_datadir/%origname

%files -n %origname-manual
%_docdir/%origname

%files -n python-module-ufc_utils
%python_sitelibdir_noarch/ufc_utils

%changelog
