%define modulename virtualenv

%def_with python3
%def_with check

Name: python-module-%modulename
Version: 12.0.5
Release: alt1

Summary: Virtual Python Environment builder
License: MIT
Group: Development/Python

Url: http://pypi.python.org/pypi/virtualenv
BuildArch: noarch

BuildRequires: python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools-tests
%endif
%if_with check
BuildPreReq: python-module-mock
BuildPreReq: python-module-nose
%if_with python3
BuildPreReq: python3-module-mock
BuildPreReq: python3-module-nose
%endif
%endif

# git://github.com/pypa/virtualenv.git
Source: %name-%version.tar

%setup_python_module %modulename

%description
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including 
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%description -l ru_RU.UTF-8
Утилита для создания изолированных окружений для Python.

С Virtualenv вы можете создать независимые наборы библиотек для каждого
вашего проекта. Опционально вы можете запретить использование системных библиотек.

Просто выполните "virtuakenv /your/dir" и полное виртуальное окружение Python будет
создано в каталоге, который вы указали (setuptools  и easy_install будут также установлены
и при вызове будут устанавливать новые библиотеки в ваше виртуальное окружение). Чтобы
выполнить ваши скрипты в вновь созданном окружение запускайте их при помощи
/your/dir/bin/python

%if_with python3
%package -n python3-module-%modulename
Summary: Virtual Python 3 Environment builder
Group: Development/Python3
%py3_provides %modulename

%description -n python3-module-%modulename
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including 
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python
%endif

%prep
%setup
rm -f virtualenv_support/*.egg
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
export LC_ALL=en_US.UTF-8
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/virtualenv %buildroot%_bindir/virtualenv3
%endif
%python_install

%if_with check
%check
py.test
%if_with python3
pushd ../python3
py.test-%_python3_version
popd
%endif
%endif

%files
%_bindir/*
%exclude %_bindir/virtualenv3
%exclude %_bindir/virtualenv-3.*
%python_sitelibdir/*
%doc docs/*

%if_with python3
%files -n python3-module-%modulename
%_bindir/virtualenv3
%_bindir/virtualenv-3.*
%python3_sitelibdir/*
%endif

%changelog
