%define oname webob

%def_with python3

Name: python-module-%oname
Version: 1.2.3
Release: alt1
Summary: WSGI request and response object
License: MIT
Group: Development/Python
Url: http://webob.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
BuildArch: noarch

# https://github.com/Pylons/webob.git
Source: WebOb-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-setuptools
%setup_python_module %oname
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

%py_requires tempita simplejson wsgiref

%description
WebOb provides wrappers around the WSGI request environment, and an
object to help create WSGI responses.

The objects map much of the specified behavior of HTTP, including header
parsing and accessors for other standard parts of the environment.

%if_with python3
%package -n python3-module-%oname
Summary: WSGI request and response object (Python 3)
Group: Development/Python3
%py3_requires tempita wsgiref

%description -n python3-module-%oname
WebOb provides wrappers around the WSGI request environment, and an
object to help create WSGI responses.

The objects map much of the specified behavior of HTTP, including header
parsing and accessors for other standard parts of the environment.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc docs/*
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc docs/*
%python3_sitelibdir/*
%endif

%changelog
