%define oname webtest

%def_with python3

Name: python-module-%oname
Version: 2.0
Release: alt1
Summary: Helper to test WSGI applications
License: MIT
Group: Development/Python
Url: http://webtest.pythonpaste.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://github.com/Pylons/webtest.git
Source: WebTest-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-setuptools
BuildPreReq: python-module-sphinx python-module-Pygments
BuildPreReq: python-module-objects.inv
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-sphinx python3-module-Pygments
%endif

%description
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.

%if_with python3
%package -n python3-module-%oname
Summary: Helper to test WSGI applications (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

# for docs
make -C docs html SPHINXBUILD=sphinx-build PYTHONPATH=`pwd`

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc docs/_build/*
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
