%define oname zc.intid
Name: python-module-%oname
Version: 1.0.1
Release: alt1
Summary: Reduced-conflict Integer Id Utility
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zc.intid/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-distribute

%py_requires ZODB3 zope.component zope.event zope.interface zope.security

%description
This package provides an API to create integer ids for any object.
Objects can later be looked up by their id as well. This functionality
is commonly used in situations where dealing with objects is
undesirable, such as in search indices or any code that needs an easy
hash of an object.

This is similar to the zope.intid package, but with two distinct
advantages:

* Induces fewer conflict errors, since object ids are not used as part
  of the stored data. The id for an object is stored in an attribute of
  the object itself, with the attribute name being configured by the
  construction of the id utility.

  This does require that the object "play nice" with this approach. At a
  minimum, the attributes used to store ids on objects should
  * persist with the rest of the object's state, and
  * not be modified by the object.

* Fewer dependencies.

Events generated on the assignment and removal of ids are generated by
the register and unregister methods rather than by the callers of those
methods.

%package tests
Summary: Tests for zc.intid
Group: Development/Python
Requires: %name = %version-%release

%description tests
This package provides an API to create integer ids for any object.
Objects can later be looked up by their id as well. This functionality
is commonly used in situations where dealing with objects is
undesirable, such as in search indices or any code that needs an easy
hash of an object.

This package contains tests for zc.intid.

%prep
%setup

%build
%python_build

%install
%python_install

%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests.*

%files tests
%python_sitelibdir/*/*/tests.*

%changelog
