%define version 4.0.5
#define subver c1
%define release alt1
%define oname zope.interface
%setup_python_module %oname

%def_with python3

Summary: Zope interfaces package
Name: python-module-%oname
Version: %version
Url: http://www.python.org/pypi/zope.interface
%ifdef subver
Release: %release.%subver
%else
Release: %release
%endif
# git://github.com/zopefoundation/zope.interface.git
Source0: %name-%version.tar
License: ZPL
Group: Development/Python
Packager: Python Development Team <python@packages.altlinux.org>

BuildPreReq: python-module-distribute python-module-zope.fixers
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-zope.fixers
%endif

%description
This is a separate distribution of the zope.interface package used in
Zope 3, along with the packages it depends on.

%if_with python3
%package -n python3-module-%oname
Summary: Zope interfaces package (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
This is a separate distribution of the zope.interface package used in
Zope 3, along with the packages it depends on.

%package -n python3-module-%oname-tests
Summary: Tests for zope.interface (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
This is a separate distribution of the zope.interface package used in
Zope 3, along with the packages it depends on.

This package contains tests for zope.interface.
%endif

%package tests
Summary: Tests for zope.interface
Group: Development/Python
Requires: %name = %version-%release

%description tests
This is a separate distribution of the zope.interface package used in
Zope 3, along with the packages it depends on.

This package contains tests for zope.interface.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%add_optflags -fno-strict-aliasing
%python_build_debug build_ext
%if_with python3
pushd ../python3
%python3_build build_ext
popd
%endif

%install
%python_module_declare %python_sitelibdir/zope
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif
 
%files
%python_sitelibdir/*
%exclude %python_sitelibdir/zope/interface/tests
%doc *.txt

%files tests
%python_sitelibdir/zope/interface/tests

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/zope/interface/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/zope/interface/tests
%endif

%changelog
