%define oname zope.tales

%def_with python3

Name: python-module-%oname
Version: 4.0.1
Release: alt1
Summary: Zope Template Application Language Expression Syntax (TALES)
License: ZPL
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.tales/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-distribute
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%py_requires zope zope.interface zope.tal

%description
Template Attribute Language - Expression Syntax.

%if_with python3
%package -n python3-module-%oname
Summary: Zope Template Application Language Expression Syntax (TALES) (Python 3)
Group: Development/Python3
%py3_requires zope zope.interface zope.tal

%description -n python3-module-%oname
Template Attribute Language - Expression Syntax.

%package -n python3-module-%oname-tests
Summary: Tests for zope.tales (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing

%description -n python3-module-%oname-tests
Template Attribute Language - Expression Syntax.

This package contains tests for zope.tales.
%endif

%package tests
Summary: Tests for zope.tales
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing

%description tests
Template Attribute Language - Expression Syntax.

This package contains tests for zope.tales.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests
%endif

%changelog
