%define oname zope.testing

%def_with python3

Name: python-module-%oname
Version: 4.1.2
Release: alt1
Summary: Zope testing helpers
License: ZPL
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.testing/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-distribute
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%py_requires zope.exceptions zope.interface

%description
This package provides a number of testing frameworks. It includes a
flexible test runner, and supports both doctest and unittest.

%if_with python3
%package -n python3-module-%oname
Summary: Zope testing helpers (Python 3)
Group: Development/Python3
%py3_requires zope.exceptions zope.interface

%description -n python3-module-%oname
This package provides a number of testing frameworks. It includes a
flexible test runner, and supports both doctest and unittest.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%endif

%changelog
