%define modulename dns

# Testing requires network access
%def_without check

Name: python3-module-%modulename
Version: 1.10.0
Release: alt2

Summary: DNS toolkit (Python 3)
License: BSD-like
Group: Development/Python
Url: http://www.dnspython.org
Packager: Python Development Team <python at packages.altlinux.org>

BuildArch: noarch

# http://www.dnspython.org/kits/%version/dnspython-%version.tar
# git://github.com/rthalley/dnspython.git
Source: %name-%version.tar

BuildPreReq: rpm-build-python3
BuildPreReq: python3-module-distribute
BuildPreReq: python-module-epydoc

%description
dnspython is a DNS toolkit for Python. It supports almost all
record types. It can be used for queries, zone transfers, and dynamic
updates.  It supports TSIG authenticated messages and EDNS0.

dnspython provides both high and low level access to DNS. The high
level classes perform queries for data of a given name, type, and
class, and return an answer set.  The low level classes allow
direct manipulation of DNS zones, messages, names, and records.

%prep
%setup
rm -f examples/._*

%build
%python3_build
%make_build doc

%install
%python3_install

%if_with check
%check
pushd tests
%make PYTHONPATH="../:$PYTHONPATH" check
popd
%endif

%files
%doc examples/ html/ ChangeLog LICENSE
%python3_sitelibdir/*

%changelog
