# vim: set ft=spec
# vim600: set fdm=marker:

# {{{ macros define
%def_enable binfmt_misc

%def_with alpha
%def_with arm
%def_without cris
%def_with x86
%def_with m68k
%def_without microblaze
%def_with mips
%def_with ppc
%def_without sh4
%def_with sparc
%def_with s390x
%def_with lm32
%def_with unicore32
%def_without xtensa

%def_disable werror
%def_enable sdl
%def_enable curses
%def_enable bluez
%def_enable vnc
%def_enable vnc_tls
%def_enable vnc_sasl
%def_enable vnc_jpeg
%def_enable vnc_png
%def_enable vde
%def_enable alsa
%def_disable esound
%def_enable pulseaudio
%def_enable oss
%def_enable aio
%def_enable blobs
%def_enable uuid
%def_enable smartcard_nss
%def_enable usb_redir
%def_disable opengl
%def_enable guest_agent
%def_enable tools
%def_enable spice
%def_enable libiscsi
%def_disable seccomp
%def_disable glusterfs

%define audio_drv_list %{?_enable_oss:oss} %{?_enable_alsa:alsa} %{?_enable_sdl:sdl} %{?_enable_esound:esd} %{?_enable_pulseaudio:pa}
%define audio_card_list ac97 es1370 sb16 adlib cs4231a gus hda

%define _group vmusers
%define rulenum 90
%define _libexecdir /usr/libexec
%define _localstatedir /var
%define _sharedstatedir /var

%global target_list_system %nil
%global target_list_user %nil

%if_with alpha
%global target_list_user %target_list_user alpha-linux-user
%endif

%if_with arm
%global target_list_system %target_list_system arm-softmmu
%global target_list_user %target_list_user arm-linux-user armeb-linux-user
%endif

%if_with cris
%global target_list_system %target_list_system cris-softmmu
%global target_list_user %target_list_user cris-linux-user
%endif

%if_with x86
%global target_list_system %target_list_system i386-softmmu x86_64-softmmu
%global target_list_user %target_list_user i386-linux-user x86_64-linux-user
%endif

%if_with m68k
%global target_list_system %target_list_system m68k-softmmu
%global target_list_user %target_list_user m68k-linux-user
%endif

%if_with microblaze
%global target_list_system %target_list_system microblaze-softmmu microblazeel-softmmu
%global target_list_user %target_list_user microblaze-linux-user microblazeel-linux-user
%endif

%if_with mips
%global target_list_system %target_list_system mips-softmmu mipsel-softmmu mips64-softmmu mips64el-softmmu
%global target_list_user %target_list_user mips-linux-user mipsel-linux-user
%endif

%if_with ppc
%global target_list_system %target_list_system ppc-softmmu ppcemb-softmmu ppc64-softmmu
%global target_list_user %target_list_user ppc-linux-user ppc64-linux-user ppc64abi32-linux-user
%endif

%if_with sh4
%global target_list_system %target_list_system sh4-softmmu sh4eb-softmmu
%global target_list_user %target_list_user sh4-linux-user sh4eb-linux-user
%endif

%if_with sparc
%global target_list_system %target_list_system sparc-softmmu sparc64-softmmu
%global target_list_user %target_list_user sparc-linux-user sparc64-linux-user sparc32plus-linux-user
%endif

%if_with s390x
%global target_list_system %target_list_system s390x-softmmu
%global target_list_user %target_list_user s390x-linux-user
%endif

%if_with lm32
%global target_list_system %target_list_system lm32-softmmu
%endif

%if_with unicore32
%global target_list_user %target_list_user unicore32-linux-user
%endif

%if_with xtensa
%global target_list_system %target_list_system xtensa-softmmu xtensaeb-softmmu
%global target_list_user %target_list_user xtensaeb-linux-user
%endif
# }}}

Name: qemu
Version: 1.4.0
Release: alt1.1.M70P.1

Summary: QEMU CPU Emulator
License: GPL/LGPL/BSD
Group: Emulators
Requires: %name-system = %version-%release, %name-user = %version-%release

URL: http://www.nongnu.org/qemu/
Source0: %name-%version.tar
Source2: qemu-kvm.control.in
Source3: qemu-kvm.init
Source4: qemu-kvm.rules
Source5: qemu-kvm.sysconfig
Source6: qemu-kvm.service
Source7: kvm-modules-load
Source8: qemu-guest-agent.rules
Source9: qemu-guest-agent.service

Patch0: qemu-alt.patch

%set_verify_elf_method fhs=relaxed

BuildRequires: glibc-devel-static zlib-devel-static glib2-devel-static
BuildRequires: texinfo perl-podlators libattr-devel libcap-devel libcap-ng-devel
BuildRequires: zlib-devel libcurl-devel libpci-devel glibc-kernheaders
BuildRequires: ipxe-roms-qemu vgabios seabios libfdt-devel
BuildRequires: libpixman-devel >= 0.18.4
%{?_enable_sdl:BuildRequires: libSDL-devel libX11-devel }
%{?_enable_curses:BuildRequires: libncurses-devel}
%{?_enable_bluez:BuildRequires: libbluez-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel}
%{?_enable_esound:BuildRequires: libesd-devel}
%{?_enable_pulseaudio:BuildRequires: libpulseaudio-devel}
%{?_enable_vnc_tls:BuildRequires: libgnutls-devel}
%{?_enable_vnc_sasl:BuildRequires: libsasl2-devel}
%{?_enable_vnc_jpeg:BuildRequires: libjpeg-devel}
%{?_enable_vnc_png:BuildRequires: libpng-devel}
%{?_enable_vde:BuildRequires: libvde-devel}
%{?_enable_aio:BuildRequires: libaio-devel}
%{?_enable_spice:BuildRequires: libspice-server-devel >= 0.12.0 spice-protocol >= 0.12.2}
%{?_enable_uuid:BuildRequires: libuuid-devel}
%{?_enable_smartcard_nss:BuildRequires: libnss-devel >= 3.12.8}
%{?_enable_usb_redir:BuildRequires: libusbredir-devel >= 0.5}
%{?_enable_opengl:BuildRequires: libGL-devel libX11-devel}
%{?_enable_guest_agent:BuildRequires: glib2-devel python-base}
%{?_enable_libiscsi:BuildRequires: libiscsi-devel >= 1.3.0}
%{?_enable_seccomp:BuildRequires: libseccomp-devel >= 1.0.0}
%{?_enable_glusterfs:BuildRequires: glusterfs3-devel}

%description
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.  QEMU has two operating modes:

* Full system emulation.  In this mode, QEMU emulates a full system
  (for example a PC), including a processor and various peripherials.
  It can be used to launch different Operating Systems without rebooting
  the PC or to debug system code.

* User mode emulation.  In this mode, QEMU can launch Linux processes
  compiled for one CPU on another CPU.  It can be used to launch the
  Wine Windows API emulator or to ease cross-compilation and
  cross-debugging.

As QEMU requires no host kernel patches to run, it is very safe and easy
to use.

%package common
Summary: QEMU CPU Emulator - common files
Group: Emulators
BuildArch: noarch
Requires(pre): control >= 0.7.2
Requires(pre): shadow-utils sysvinit-utils
Requires: vgabios
Requires: seabios
Requires: ipxe-roms-qemu
Requires: %name-img = %version-%release

%description common
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.
This package contains common files for qemu.

%package system
Summary: QEMU CPU Emulator - full system emulation
Group: Emulators
Requires: %name-common = %version-%release
Provides: qemu-kvm  = %version-%release
Obsoletes: qemu-kvm < %version-%release

%description system
Full system emulation.  In this mode, QEMU emulates a full system
(for example a PC), including a processor and various peripherials.
It can be used to launch different Operating Systems without rebooting
the PC or to debug system code.

%package user
Summary: QEMU CPU Emulator - user mode emulation
Group: Emulators
Requires: %name-common = %version-%release

%description user
User mode emulation.  In this mode, QEMU can launch Linux processes
compiled for one CPU on another CPU.  It can be used to launch the
Wine Windows API emulator or to ease cross-compilation and
cross-debugging.

%package user-binfmt_misc
Summary: QEMU CPU Emulator - user mode emulation, binfmt_misc version
Group: Emulators
Requires: %name-aux = %version-%release

%description user-binfmt_misc
User mode emulation.  In this mode, QEMU can launch Linux processes
compiled for one CPU on another CPU.  It can be used to launch the
Wine Windows API emulator or to ease cross-compilation and
cross-debugging.
This package contains static version with enabled binfmt_misc support.
Suitable for hasher.

%package img
Summary: QEMU command line tool for manipulating disk images
Group: Emulators
Provides: qemu-kvm-img
Obsoletes: qemu-kvm-img < %version-%release
Requires: %name-aux = %version-%release

%description img
This package provides a command line tool for manipulating disk images

%package guest-agent
Summary: QEMU guest agent
Group: Emulators
Requires: %name-aux = %version-%release

%description guest-agent
QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation.

This package provides an agent to run inside guests, which communicates
with the host over a virtio-serial channel named "org.qemu.guest_agent.0"

This package does not need to be installed on the host OS.

%package doc
Summary: User documentation for %name
Group: Documentation
BuildArch: noarch
Requires: %name-aux = %version-%release

%description doc
User documentation for %name

%package aux
Summary: QEMU auxiliary package
Group: Emulators
BuildArch: noarch

%description aux
QEMU is a generic and open source processor emulator which achieves
good emulation speed by using dynamic translation.

This is an auxiliary package.

%package -n libcacard
Summary: CA Card library
Group: System/Libraries
License: LGPLv2.1+

%description -n libcacard
Common Access Card (CAC) emulation library.

%package -n libcacard-devel
Summary: CAC Emulation devel
Group: Development/C
Requires: libcacard = %version-%release
License: LGPLv2.1+

%description -n libcacard-devel
CAC emulation development files.

%package -n libcacard-tools
Summary: CAC Emulation tools
Group: Development/Other
Requires: libcacard = %version-%release

%description -n libcacard-tools
CAC emulation tools.

%prep
%setup
%patch -p1
cp -f %SOURCE2 qemu-kvm.control.in

%build
export CFLAGS="%optflags"
%if_enabled binfmt_misc
# non-GNU configure
./configure \
	--target-list='%target_list_user' \
	--prefix=%_prefix \
	--static \
	--disable-debug-tcg \
	--disable-sparse \
	--disable-strip \
	--disable-system \
	--enable-nptl \
	--enable-guest-base \
	--disable-smartcard-nss \
	--disable-usb-redir \
	--disable-linux-aio

# Please do not touch this
sed -i "/TARGET_ARM/ {
N
/cpu_model/ s,any,cortex-a8,
}" linux-user/main.c

%make_build
mv arm-linux-user/qemu-arm arm-linux-user/qemu-armh

sed -i '/cpu_model =/ s,cortex-a8,arm926,' linux-user/main.c
%make_build
find -regex '.*linux-user/qemu.*' -perm 755 -exec mv '{}' '{}'.static ';'
%make_build clean
sed -i '/cpu_model =/ s,arm926,any,' linux-user/main.c
%endif

# non-GNU configure
./configure \
	--target-list='%target_list_system %target_list_user' \
	--prefix=%_prefix \
	--sysconfdir=%_sysconfdir \
	--libdir=%_libdir \
	--extra-cflags="%optflags" \
	%{subst_enable werror} \
	%{?_disable_sdl:--disable-sdl} \
	%{?_disable_curses:--disable-curses} \
	%{subst_enable bluez} \
	%{subst_enable vnc} \
	%{?_disable_vnc_tls:--disable-vnc-tls} \
	%{?_disable_vnc_sasl:--disable-vnc-sasl} \
	%{?_disable_vnc_jpeg:--disable-vnc-jpeg} \
	%{?_disable_vnc_png:--disable-vnc-png} \
	%{?_disable_vde:--disable-vde} \
	%{?_disable_aio:--disable-linux-aio} \
	%{?_disable_blobs: --disable-blobs} \
	%{?_disable_spice:--disable-spice} \
	%{?_disable_uuid:--disable-uuid} \
	--disable-debug-tcg \
	--disable-sparse \
	--disable-strip \
	--audio-drv-list="%audio_drv_list" \
	--audio-card-list="%audio_card_list" \
	--enable-mixemu \
	--disable-xen \
	--disable-brlapi \
	--enable-curl \
	--enable-fdt \
	--enable-kvm \
	--enable-nptl \
	--with-system-pixman \
	%{?_enable_smartcard_nss:--enable-smartcard-nss} \
	%{?_enable_usb_redir:--enable-usb-redir} \
	%{subst_enable opengl} \
	%{subst_enable libiscsi} \
	%{?_disable_guest_agent:--disable-guest-agent} \
	%{subst_enable tools} \
	--enable-guest-base \
	--enable-pie

%make_build

sed -i 's/@GROUP@/%_group/g' qemu-kvm.control.in

%install
%makeinstall_std

%define docdir %_docdir/%name-%version
mv %buildroot%_docdir/qemu %buildroot%docdir
install -m644 Changelog LICENSE TODO %buildroot%docdir/

%if_enabled binfmt_misc
find -regex '.*linux-user/qemu.*\.static' -exec install -m755 '{}' %buildroot%_bindir ';'
%endif

ln -s %_bindir/qemu-system-x86_64 %buildroot%_bindir/qemu
ln -s %_bindir/qemu-system-x86_64 %buildroot%_bindir/kvm
ln -s %_bindir/qemu-system-x86_64 %buildroot%_bindir/qemu-kvm

rm -f %buildroot%_bindir/check-*
rm -f %buildroot%_sysconfdir/udev/rules.d/*

install -D -m 0755 %SOURCE3 %buildroot%_initdir/%name-kvm
install -D -m 0644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name-kvm
install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/udev/rules.d/%rulenum-%name-kvm.rules
install -D -m 0755 %name-kvm.control.in %buildroot%_controldir/kvm

install -D -m 0644 %SOURCE6 %buildroot%_unitdir/%name-kvm.service
install -D -m 0755 %SOURCE7 %buildroot/lib/systemd/kvm-modules-load
install -D -m 0644 %SOURCE8 %buildroot/lib/udev/rules.d/%rulenum-%name-guest-agent.rules
install -D -m 0644 %SOURCE9 %buildroot%_unitdir/%name-guest-agent.service

%if_enabled vnc_sasl
install -D -p -m 0644 qemu.sasl %buildroot%_sysconfdir/sasl2/%name.conf
%endif


#rm -f %buildroot%_datadir/*/openbios*
rm -f %buildroot%_datadir/%name/pxe*rom
rm -f %buildroot%_datadir/%name/vgabios*bin
rm -f %buildroot%_datadir/%name/bios.bin
#rm -f %buildroot%_datadir/%name/petalogix-s3adsp1800.dtb
#rm -f %buildroot%_datadir/%name/video.x
#rm -f %buildroot%_datadir/%name/bamboo.dtb
#rm -f %buildroot%_datadir/%name/ppc_rom.bin

# the pxe ipxe images will be symlinks to the images on
# /usr/share/ipxe, as QEMU doesn't know how to look
# for other paths, yet.
pxe_link() {
  ln -s ../../../usr/lib/ipxe/$2.rom %buildroot%_datadir/%name/pxe-$1.rom
}

pxe_link rtl8139 rtl8139
pxe_link e1000 e1000_82540
pxe_link virtio virtio-net
pxe_link pcnet pcnet32
pxe_link ne2k_isa ne2k_isa
pxe_link ne2k_pci ns8390
pxe_link eepro100 eepro100

ln -s ../vgabios/VGABIOS-lgpl-latest.bin  %buildroot%_datadir/%name/vgabios.bin
ln -s ../vgabios/VGABIOS-lgpl-latest.cirrus.bin %buildroot%_datadir/%name/vgabios-cirrus.bin
ln -s ../vgabios/VGABIOS-lgpl-latest.qxl.bin %buildroot%_datadir/%name/vgabios-qxl.bin
ln -s ../vgabios/VGABIOS-lgpl-latest.stdvga.bin %buildroot%_datadir/%name/vgabios-stdvga.bin
ln -s ../vgabios/VGABIOS-lgpl-latest.vmware.bin %buildroot%_datadir/%name/vgabios-vmware.bin
ln -s ../../../usr/lib/seabios/bios.bin %buildroot%_datadir/%name/bios.bin

%check
%make V=1 check

%pre common
%_sbindir/groupadd -r -f %_group
if [ -f %_controldir/qemu-kvm ];then
%pre_control qemu-kvm
mv -f /var/run/control/qemu-kvm /var/run/control/kvm
else
%pre_control kvm
fi

%post common
%post_control -s vmusers kvm
%post_service %name-kvm

%preun common
%preun_service %name-kvm

%files

%files common
%_datadir/qemu
%_man1dir/qemu*
%_man8dir/qemu*
%_sysconfdir/udev/rules.d/%rulenum-%name-kvm.rules
%_initdir/%name-kvm
%config(noreplace) %_sysconfdir/sysconfig/*
%_controldir/*
%if_enabled vnc_sasl
%config(noreplace) %_sysconfdir/sasl2/%name.conf
%endif
%_sysconfdir/%name
%_unitdir/%name-kvm.service
/lib/systemd/kvm-modules-load

%files system
%_bindir/qemu
%_bindir/qemu-kvm
%_bindir/kvm
%_bindir/qemu*system*

%files user
%_bindir/qemu-*
%exclude %_bindir/qemu*system*
%exclude %_bindir/qemu-kvm
%if_enabled binfmt_misc
%exclude %_bindir/qemu-*.static
%endif
%exclude %_bindir/qemu-img
%exclude %_bindir/qemu-io
%exclude %_bindir/qemu-nbd
%exclude %_bindir/qemu-ga

%if_enabled binfmt_misc
%files user-binfmt_misc
%_bindir/qemu-*.static
%endif

%files img
%_bindir/qemu-img
%_bindir/qemu-io
%_bindir/qemu-nbd
%_bindir/virtfs-proxy-helper
%_man1dir/virtfs-proxy-helper.*
%_libexecdir/qemu-bridge-helper

%files guest-agent
%_bindir/qemu-ga
/lib/udev/rules.d/%rulenum-%name-guest-agent.rules
%_unitdir/%name-guest-agent.service

%files doc
%docdir/
%exclude %docdir/LICENSE

%files aux
%dir %docdir/
%docdir/LICENSE

%files -n libcacard
%_libdir/libcacard.so.*

%files -n libcacard-devel
%_includedir/cacard
%_pkgconfigdir/libcacard.pc
%_libdir/libcacard.so

%files -n libcacard-tools
%_bindir/vscclient

%changelog
