%define branch 0.11
%define svn svn6521

%define rel alt0.M70T

%if "%rel" == "alt0.M51"
%define PLUG_DISABLE "UDISKS2_PLUGIN OPUS_PLUGIN WITH_NEW_JACK WITH_QSUI"
%define PLUG_ENABLE "FFMPEG_LEGACY UDISKS_PLUGIN JACK_PLUGIN"
%endif

%if "%rel" == "alt0.M60T"
%define PLUG_DISABLE "UDISKS2_PLUGIN"
%define PLUG_ENABLE "UDISKS_PLUGIN WITH_NEW_JACK"
%endif

%if "%rel" == "alt0.M70T"
%define PLUG_DISABLE "UDISKS_PLUGIN"
%define PLUG_ENABLE "UDISKS2_PLUGIN WITH_NEW_JACK"
%endif

%if "%rel" == "alt0.M80P"
%define PLUG_DISABLE "UDISKS_PLUGIN"
%define PLUG_ENABLE "UDISKS2_PLUGIN WITH_NEW_JACK"
%endif

%if "%rel" == "alt1"
%define PLUG_DISABLE "UDISKS_PLUGIN"
%define PLUG_ENABLE "UDISKS2_PLUGIN WITH_NEW_JACK"
%endif

Version: %branch.0
Epoch: 1
Name: qmmp
Release: %rel.%svn
Summary: QMMP - Qt-based multimedia player
Summary(ru_RU.UTF8): Qmmp - мультимедиа проигрыватель на базе Qt
Summary(uk_UA.UTF8): Qmmp - мультимедіа програвач на базі Qt
License: GPLv2
Group: Sound
Packager: Motsyo Gennadi <drool@altlinux.ru>
Url: http://qmmp.ylsoftware.com/
Source0: %name-%branch-%svn.tar.bz2

Requires: unzip winamplike-skins lib%name = %version-%release

BuildPreReq: rpm-build-wlskins doxygen

BuildRequires: gcc-c++ libavformat-devel
BuildRequires: libcurl-devel libfaad-devel libmad-devel libmodplug-devel
BuildRequires: libmpcdec-devel libpulseaudio-devel >= 0.9.15 libqt4-devel
BuildRequires: libsoxr-devel libtag-devel >= 1.6 libvorbis-devel
BuildRequires: libwavpack-devel libalsa-devel libflac-devel libbs2b-devel >= 3.0
BuildRequires: libprojectM-devel >= 2.0.1 jackit-devel xorg-xf86miscproto-devel
BuildRequires: libenca-devel libcddb-devel libmms-devel >= 0.4 libwildmidi-devel >= 0.2.3.4
BuildRequires: libgme-devel libGLU-devel libsidplayfp-devel >= 1.0.3

# for libcdio-paranoia
%define libcdio libcdio-devel
%if "%rel" == "alt1"
%define libcdio libcdio-paranoia-devel
%endif
%if "%rel" == "alt0.M80P"
%define libcdio libcdio-paranoia-devel
%endif
BuildRequires: %libcdio

%if "%rel" != "alt0.M51"
# disable for 5.1
BuildRequires: libopusfile-devel
%endif

%description
QMMP is an audio-player, written with help of Qt library.
The user interface is similar to winamp or xmms.

Supported formats:
- MPEG1 layer 2/3
- Ogg Vorbis
- Opus
- Native FLAC, Ogg FLAC
- Musepack
- WavePack
- tracker modules (mod, s3m, it, xm, etc)
- ADTS AAC
- CD Audio
- WMA, Monkey's Audio (and other formats provided by FFmpeg library)
- PCM WAVE (and other formats provided by libsndfile library)
- midi
- chiptune formats (AY, GBS, GYM, HES, KSS, NSF, NSFE, SAP, SPC, VGM, VGZ, VTX)

DSP effects:
- BS2B effect
- sample rate converter
- LADSPA effects
- extra stereo
- crossfade (Experimental)

Visual effects:
- projectM visualization
- spectrum analyzer

Output system support:
- OSS
- ALSA (Linux)
- Pulse Audio
- JACK
- WaveOut (Win32)

Other features:
- XMMS and Winamp 2.x skins support
- 10-band equalizer
- MP3, Vorbis, AAC, AAC+ streams support
- mms support
- MPRIS (1.0 and 2.0)
- removable device detection (via HAL or UDisks)
- video playback via Mplayer
- lyrics (using lyrics.wikia.com)
- cover art support
- CUE sheet support
- embedded CUE support (for FLAC and WavPack)
- multiple playlists
- automatic charset detection for cue files and ShoutCast metadata
- playlist formats: m3u, pls, xspf
- ReplayGain support
- Last.fm/Libre.fm scrobbler
- CDDB support

%description -l ru_RU.UTF8
Программа является аудио-плеером, написанным с использованием библиотеки Qt.
Пользовательский интерфейс сходный с winamp или xmms.

Поддерживаемые форматы:
- MPEG1 layer 2/3
- Ogg Vorbis
- Opus
- Native FLAC, Ogg FLAC
- Musepack
- WavePack
- трекерные форматы (mod, s3m, it, xm и т.д.)
- ADTS AAC
- CD Audio
- WMA, Monkey's Audio (и др. форматы библиотеки FFmpeg)
- PCM WAVE (и др. форматы библиотеки libsndfile)
- midi
- форматы звука игровых консолей (AY, GBS, GYM, HES, KSS, NSF, NSFE, SAP, SPC, VGM, VGZ, VTX)

Аудио-эффекты:
- эффект BS2B
- Передискретизация
- эффекты LADSPA
- расширение стереобазы
- плавный переход между треками (экспериментальный)

Визуальные эффекты:
- визуализация projectM
- анализатор спектра

Системы вывода звука:
- OSS
- ALSA (Linux)
- Pulse Audio
- JACK
- WaveOut (Win32)

Другие возможности:
- поддержка обложек XMMS и Winamp 2.x
- 10-полосный эквалайзер
- поддержка потоков MP3, Vorbis, AAC, AAC+
- поддержка протокола MMS
- MPRIS (1.0 и 2.0)
- автоопределение съёмных устройств (с помощью HAL или UDisks)
- воспроизведение видео с помощью Mplayer-а
- получение текстов песен с lyrics.wikia.com
- просмотр обложек
- поддержка CUE
- поддержка "встроенного" CUE (для файлов FLAC и WavPack)
- возможность использовать несколько списков воспроизведения
- автоматической определение кодировки для cue-файлов и ShoutCast-метаданных
- поддерживаемые форматы списков воспроизведения: m3u, pls, xspf
- поддержка ReplayGain
- скробблер Last.fm/Libre.fm
- поддержка CDDB

%description -l uk_UA.UTF8
Програма є аудіо-плеєром, написаним з використанням бібліотеки Qt.
Інтерфейс користувача подібний до winamp чи xmms.

Підтримувані формати:
- MPEG1 layer 2/3
- Ogg Vorbis
- Opus
- Native FLAC, Ogg FLAC
- Musepack
- WavePack
- трекерные форматы (mod, s3m, it, xm и т.д.)
- ADTS AAC
- CD Audio
- WMA, Monkey's Audio (та інші формати бібліотеки FFmpeg)
- PCM WAVE (та інші формати бібліотеки libsndfile)
- midi
- формати звуку ігрових консолей (AY, GBS, GYM, HES, KSS, NSF, NSFE, SAP, SPC, VGM, VGZ, VTX)

Аудіо-ефекти:
- Ефект BS2B
- Передискретизація
- Ефекти LADSPA
- розширення стереобази
- плавний перехід між треками (експериментально)

Візуальні ефекти:
- Візуалізація projectM
- Аналізатор спектру

Системы вывода звукаСистеми виведення звуку:
- OSS
- ALSA (Linux)
- Pulse Audio
- JACK
- WaveOut (Win32)

Інші можливості:
- Підтримка обкладинок Xmms і Winamp 2.x
- 10-смуговий еквалайзер
- Підтримка потоків MP3, Vorbis, AAC, AAC +
- Підтримка протоколу MMS (експериментальна)
- MPRIS
- Автовизначення знімних пристроїв (за допомогою HAL або UDisks)
- Відтворення відео за допомогою MPlayer-а
- Отримання текстів пісень з lyricsplugin.com
- Перегляд обкладинок
- Підтримка CUE
- Підтримка "вбудованого" CUE (для файлів FLAC і WavPack)
- Можливість використовувати декілька списків відтворення
- Автоматичне визначення кодування для cue-файлів і ShoutCast-метаданих
- Підтримувані формати списків відтворення: m3u, pls, xspf
- Підтримка ReplayGain
- Скробблер Last.fm/Libre.fm
- Підтримка CDDB

%package -n %name-docs
Summary: Documentation for Qmmp
Group: Documentation
BuildArch: noarch

%description -n %name-docs
Documentation for Qmmp

%package -n lib%name
Summary: Shared libraries for Qmmp
Group: System/Libraries

%description -n lib%name
Shared libraries for Qmmp

# Output plugins
%package -n %name-out-pulseaudio
Summary: Qmmp PulseAudio Output Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-out-pulseaudio
Qmmp PulseAudio Output Plugin

%package -n %name-out-oss
Summary: Qmmp OSS Output Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-out-oss
Qmmp OSS Output Plugin

%package -n %name-out-jack
Summary: Qmmp Jack Output Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-out-jack
Qmmp Jack Output Plugin

%package -n %name-out-qtmultimedia
Summary: Qmmp Qt Multimedia Output Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-out-qtmultimedia
Qmmp Qt Multimedia Output Plugin

%package -n %name-out-null
Summary: Qmmp Null Output Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-out-null
Qmmp Null Output Plugin

# Input plugins
%package -n %name-in-ffmpeg
Summary: Qmmp FFMPEG Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-ffmpeg
Qmmp FFMPEG Audio Plugin

%package -n %name-in-flac
Summary: Qmmp FLAC Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-flac
Qmmp FLAC Audio Plugin

%package -n %name-in-musepack
Summary: Qmmp Musepack Audio Plugin
Group: Sound
Requires: qmmp = %version-%release libtag >= 1.6

%description -n %name-in-musepack
Qmmp Musepack Audio Plugin

%package -n %name-in-sndfile
Summary: Qmmp Sndfile Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-sndfile
Qmmp Sndfile Audio Plugin

%package -n %name-in-wavpack
Summary: Qmmp WavPack Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-wavpack
Qmmp WavPack Audio Plugin

%package -n %name-in-modplug
Summary: Qmmp ModPlug Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-modplug
Qmmp ModPlug Audio Plugin

%package -n %name-in-cue
Summary: Qmmp Cue Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-cue
Qmmp Cue Audio Plugin

%package -n %name-in-aac
Summary: Qmmp AAC Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-aac
Qmmp AAC Audio Plugin

%package -n %name-in-mplayer
Summary: Qmmp MPlayer Plugin
Group: Video
Requires: qmmp = %version-%release mplayer

%description -n %name-in-mplayer
Qmmp MPlayer Plugin

%package -n %name-in-cdaudio
Summary: Qmmp CDAudio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-cdaudio
Qmmp CDAudio Plugin

%package -n %name-in-midi
Summary: Qmmp Midi Plugin
Group: Sound
Requires: qmmp = %version-%release
Requires: libwildmidi

%description -n %name-in-midi
Qmmp Midi Plugin, used WildMidi

%package -n %name-in-gme
Summary: Qmmp GME Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-gme
Qmmp GME Audio Plugin

%package -n %name-in-opus
Summary: Qmmp Opus Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-opus
Qmmp Opus Audio Plugin

%package -n %name-in-sid
Summary: Qmmp SID Audio Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-in-sid
This plugin plays Commodore 64 music files using libsidplayfp library

# Visualization plugins
%package -n %name-vis-analyzer
Summary: Qmmp Analyzer Visual Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-vis-analyzer
Qmmp Analyzer Visual Plugin

%package -n %name-vis-projectm
Summary: Qmmp ProjectM Visual Plugin
Group: Sound
Requires: qmmp = %version-%release libprojectM >= 2.0.1

%description -n %name-vis-projectm
Qmmp ProjectM Visual Plugin

# Effects plugins
%package -n %name-eff-soxr
Summary: Qmmp SoX Resampler Plugin
Group: Sound
Requires: qmmp = %version-%release
Provides: %name-eff-srconverter
Obsoletes: %name-eff-srconverter

%description -n %name-eff-soxr
Qmmp SoX Resampler Plugin

%package -n %name-eff-bs2b
Summary: Qmmp BS2B Effect Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-eff-bs2b
Qmmp BS2B Effect Plugin

%package -n %name-eff-ladspa
Summary: Qmmp LADSPA Effect Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-eff-ladspa
Qmmp LADSPA Effect Plugin

%package -n %name-eff-crossfade
Summary: Qmmp Crossfade Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-eff-crossfade
Qmmp Crossfade Plugin

%package -n %name-eff-extrastereo
Summary: Qmmp Extra Stereo Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-eff-extrastereo
Qmmp Extra Stereo Plugin

# Transports plugins
%package -n %name-http
Summary: Qmmp HTTP Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-http
Qmmp HTTP Plugin

%package -n %name-mms
Summary: Qmmp MMS Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-mms
Qmmp Plugin for MMS stream protocol support

# Interface plugins
%package -n %name-qsui
Summary: Qmmp Simple Ui - simple user interface based on standard widgets set
Summary(ru_RU.UTF8): Qmmp Simple Ui - простой пользовательский интерфейс с использованием стандартных элементов
Summary(uk_UA.UTF8): Qmmp Simple Ui - простий інтерфейс користувача з використанням стандартних елементів
Group: Sound
Requires: qmmp >= %version-%release
Provides: qmmp-plugin-pack-qsui
Obsoletes: qmmp-plugin-pack-qsui

%description -n %name-qsui
Qmmp Simple Ui - simple user interface based on standard widgets set for Qmmp.

%description -l ru_RU.UTF8 -n %name-qsui
Qmmp Simple Ui - простой пользовательский интерфейс с использованием стандартных элементов для Qmmp.

%description -l uk_UA.UTF8 -n %name-qsui
Qmmp Simple Ui - простий інтерфейс користувача з використанням стандартних елементів для Qmmp.


# General plugins
%package -n %name-converter
Summary: Qmmp Converter Plugin
Group: Sound
Requires: qmmp = %version-%release
Requires: /usr/bin/oggenc lame flac wavpack

%description -n %name-converter
Qmmp Converter Plugin. This plugin converts supported audio
files to other file formats using external command-line encoders.

%package -n %name-mpris
Summary: Qmmp MPRIS Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-mpris
Qmmp MPRIS Plugin

%package -n %name-notifier
Summary: Qmmp Notifier Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-notifier
Qmmp Notifier Plugin

%package -n %name-kdenotify
Summary: Qmmp notification plugin for KDE4
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-kdenotify
Qmmp notification plugin for KDE4

%package -n %name-scrobbler
Summary: Qmmp AudioScrobbler Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-scrobbler
Qmmp AudioScrobbler Plugin

%package -n %name-statusicon
Summary: Qmmp Status Icon Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-statusicon
Qmmp Status Icon Plugin

%package -n %name-lyrics
Summary: Qmmp Lyrics Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-lyrics
Qmmp Lyrics Plugin

%package -n %name-hal
Summary: Qmmp HAL Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-hal
Qmmp HAL Plugin

%package -n %name-hotkey
Summary: Qmmp Global Hotkey Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-hotkey
Qmmp Global Hotkey Plugin. This plugin adds support
for multimedia keys or global key combinations

%package -n %name-gnomehotkey
Summary: Qmmp Gnome Hotkey Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-gnomehotkey
Qmmp Gnome Hotkey Plugin. This plugin adds
support of the GNOME/Cinnamon hotkeys

%package -n %name-fileops
Summary: Qmmp file operations Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-fileops
Qmmp file operations Plugin

%package -n %name-covermanager
Summary: Qmmp cover manager Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-covermanager
Qmmp cover manager Plugin

%package -n %name-udisks
Summary: Qmmp UDisks Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-udisks
Qmmp UDisks Plugin

%package -n %name-streambrowser
Summary: Qmmp Stream Browser Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-streambrowser
This Qmmp plugin allows to add stream from IceCast stream directory

%package -n %name-copypaste
Summary: Qmmp Copy/Paste Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-copypaste
This plugin allows to copy selected tracks from one playlist to another

%package -n %name-trackchange
Summary: Qmmp Track Change Plugin
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-trackchange
This plugin executes external command when current track is changed

%package -n %name-rgscan
Summary: ReplayGain Scanner Plugin for Qmmp
Group: Sound
Requires: qmmp = %version-%release

%description -n %name-rgscan
This plugin scans audio files and gives information for volume normalization

%package -n lib%name-devel
Summary: Qmmp header files
Group: Development/C++
Requires: lib%name = %version-%release
Provides: %name-devel
Obsoletes: %name-devel

%description -n lib%name-devel
%name-devel contains the header files needed to develop
programs which make use of Qmmp.

%package -n %name-full
Summary: QMMP - Qt-based multimedia player
Group: Sound
BuildArch: noarch
Requires: qmmp qmmp-in-wavpack qmmp-mpris qmmp-notifier
Requires: qmmp-eff-soxr qmmp-in-ffmpeg qmmp-in-mplayer
Requires: qmmp-in-flac qmmp-out-pulseaudio qmmp-in-modplug qmmp-in-midi
Requires: qmmp-in-musepack qmmp-statusicon qmmp-in-sndfile qmmp-in-cue
Requires: qmmp-vis-analyzer qmmp-scrobbler qmmp-hal qmmp-hotkey qmmp-gnomehotkey
Requires: qmmp-eff-bs2b qmmp-vis-projectm qmmp-fileops qmmp-converter
Requires: qmmp-out-jack qmmp-out-oss qmmp-out-null qmmp-http qmmp-mms
Requires: qmmp-kdenotify qmmp-eff-ladspa qmmp-covermanager qmmp-rgscan
Requires: qmmp-eff-crossfade qmmp-udisks qmmp-in-gme qmmp-in-sid
Requires: qmmp-streambrowser qmmp-trackchange qmmp-copypaste qmmp-eff-extrastereo
Requires: qmmp-out-qtmultimedia

%if "%rel" != "alt0.M51"
# disable for 5.1
Requires: qmmp-in-opus qmmp-qsui
%endif

%description -n %name-full
Virtual package for full installation Qmmp (exclude %name-devel).

%prep
%setup -q -n %name-%branch-svn

%build
# # with CMake
# # cmake \
# # 	-DCMAKE_INSTALL_PREFIX=%prefix \
# # 	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
# # 	-DCMAKE_C_FLAGS:STRING="%optflags" \
# # 	-DLIB_DIR:STRING=%_lib \
# # 	-DUSE_OSS:BOOL=TRUE

# # with QMake
subst 's|taglib mad|taglib libmad|g' src/plugins/Input/mad/mad.pro
export PATH=$PATH:%_qt4dir/bin
qmake	"QMAKE_CFLAGS+=%optflags" \
	"QMAKE_CXXFLAGS+=%optflags" \
	LIB_DIR=/%_lib \
	'DISABLED_PLUGINS=OSS4_PLUGIN %PLUG_DISABLE' \
	'CONFIG+=%PLUG_ENABLE QMMP_DEFAULT_OUTPUT=pulse' \
	%name.pro
%make_build VERBOSE=1

cd doc && doxygen Doxyfile

%install
# # with CMake
# # %make DESTDIR=%buildroot install

# # with QMake
%make INSTALL_ROOT=%buildroot%prefix install
cp src/qmmpui/{playlistheadermodel.h,metadataformatter.h} %buildroot%_includedir/qmmpui/

mkdir -p %buildroot%_datadir/%name
ln -s %_wlskindir %buildroot%_datadir/%name/skins
mkdir -p %buildroot/{%_miconsdir,%_niconsdir,%_liconsdir}

%files
%dir %_libdir/%name
%dir %_libdir/%name/Input
%dir %_libdir/%name/Ui
%dir %_libdir/%name/Output
%dir %_libdir/%name/Engines
%dir %_libdir/%name/Transports
%dir %_libdir/%name/PlayListFormats
%dir %_libdir/%name/CommandLineOptions
%dir %_libdir/%name/FileDialogs
%dir %_libdir/%name/Effect
%dir %_libdir/%name/General
%dir %_libdir/%name/Visual
%_bindir/*
%_desktopdir/*
%_libdir/%name/Input/libmad*
%_libdir/%name/Input/libvorbis*
%_libdir/%name/Ui/libskinned*
%_libdir/%name/Output/libalsa*
%_libdir/%name/PlayListFormats/*.so
%_libdir/%name/CommandLineOptions/*.so
%_libdir/%name/FileDialogs/*.so
%_datadir/%name/
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/*

%files -n lib%name
%_libdir/*.so.0
%_libdir/*.so.0.11*

# Output plugins
%files -n %name-out-pulseaudio
%_libdir/%name/Output/libpulseaudio*

%files -n %name-out-oss
%_libdir/%name/Output/liboss*

%files -n %name-out-jack
%_libdir/%name/Output/libjack*

%files -n %name-out-qtmultimedia
%_libdir/%name/Output/libqtmultimedia*

%files -n %name-out-null
%_libdir/%name/Output/libnull*

# Input plugins
%files -n %name-in-ffmpeg
%_libdir/%name/Input/libffmpeg*

%files -n %name-in-flac
%_libdir/%name/Input/libflac*

%files -n %name-in-musepack
%_libdir/%name/Input/libmpc*

%files -n %name-in-sndfile
%_libdir/%name/Input/libsndfile*

%files -n %name-in-wavpack
%_libdir/%name/Input/libwavpack*

%files -n %name-in-cue
%_libdir/%name/Input/libcue*

%files -n %name-in-aac
%_libdir/%name/Input/libaac*

%files -n %name-in-modplug
%_libdir/%name/Input/libmodplug*

%files -n %name-in-mplayer
%_libdir/%name/Engines/libmplayer*

%files -n %name-in-cdaudio
%_libdir/%name/Input/libcdaudio*

%files -n %name-in-midi
%_libdir/%name/Input/libwildmidi*

%files -n %name-in-gme
%_libdir/%name/Input/libgme*

%files -n %name-in-sid
%_libdir/%name/Input/libsid*

%if "%rel" != "alt0.M51"
# disable for 5.1
%files -n %name-in-opus
%_libdir/%name/Input/libopus*
%endif

# Visualization plugins
%files -n %name-vis-analyzer
%_libdir/%name/Visual/libanalyzer*

%files -n %name-vis-projectm
%_libdir/%name/Visual/libprojectm*

# Effects plugins
%files -n %name-eff-soxr
%_libdir/%name/Effect/libsoxr*

%files -n %name-eff-bs2b
%_libdir/%name/Effect/libbs2b*

%files -n %name-eff-ladspa
%_libdir/%name/Effect/libladspa*

%files -n %name-eff-crossfade
%_libdir/%name/Effect/libcrossfade*

%files -n %name-eff-extrastereo
%_libdir/%name/Effect/libstereo*

# Transports plugins
%files -n %name-http
%_libdir/%name/Transports/libhttp*

%files -n %name-mms
%_libdir/%name/Transports/libmms*

# Interface plugins
%if "%rel" != "alt0.M51"
%files -n %name-qsui
%_libdir/%name/Ui/libqsui*
%endif

# General plugins
%files -n %name-converter
%_libdir/%name/General/libconverter*

%files -n %name-mpris
%_libdir/%name/General/libmpris*

%files -n %name-notifier
%_libdir/%name/General/libnotifier*

%files -n %name-kdenotify
%_libdir/%name/General/libkdenotify*

%files -n %name-scrobbler
%_libdir/%name/General/libscrobbler*

%files -n %name-statusicon
%_libdir/%name/General/libstatusicon*

%files -n %name-lyrics
%_libdir/%name/General/liblyrics*

%files -n %name-hal
%_libdir/%name/General/libhal*

%files -n %name-hotkey
%_libdir/%name/General/libhotkey*

%files -n %name-gnomehotkey
%_libdir/%name/General/libgnomehotkey*

%files -n %name-fileops
%_libdir/%name/General/libfileops*

%files -n %name-covermanager
%_libdir/%name/General/libcovermanager*

%files -n %name-udisks
%_libdir/%name/General/libudisks*

%files -n %name-streambrowser
%_libdir/%name/General/libstreambrowser*

%files -n %name-trackchange
%_libdir/%name/General/libtrackchange*

%files -n %name-copypaste
%_libdir/%name/General/libcopypaste*

%files -n %name-rgscan
%_libdir/%name/General/librgscan*

%files -n lib%name-devel
%dir %_includedir/%name
%dir %_includedir/%{name}ui
%_pkgconfigdir/*.pc
%_includedir/%name/*.h
%_includedir/%{name}ui/*.h
%_libdir/*.so

%files -n %name-docs
%doc AUTHORS ChangeLog* README* doc/html

%files -n %name-full

%changelog
