Summary: Command-line tools and library for transforming PDF files
Name: qpdf
Version: 3.0.2
Release: alt1
License: Artistic 2.0
Group: System/Base
Url: http://qpdf.sourceforge.net/
Source0: http://downloads.sourceforge.net/sourceforge/qpdf/qpdf-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: zlib-devel xml-utils xsltproc docbook-style-xsl
BuildRequires: pcre-devel

BuildRequires: perl-base

# for autoreconf
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: gcc-c++

Requires: lib%name = %version-%release

%package -n lib%name
Summary: QPDF library for transforming PDF files
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for QPDF library
Group: Development/C
Requires: lib%name = %version-%release

%package doc
Summary: QPDF Manual
Group: Documentation
BuildArch: noarch

%description
QPDF is a command-line program that does structural, content-preserving
transformations on PDF files. It could have been called something
like pdf-to-pdf. It includes support for merging and splitting PDFs
and to manipulate the list of pages in a PDF file. It is not a PDF viewer
or a program capable of converting PDF into other formats.

%description -n lib%name
QPDF is a C++ library that inspect and manipulate the structure of PDF files.
It can encrypt and linearize files, expose the internals of a PDF file,
and do many other operations useful to PDF developers.

%description -n lib%name-devel
Header files and libraries necessary
for developing programs using the QPDF library.

%description doc
QPDF Manual

%prep
%setup
%patch0 -p1

%build
autoreconf --verbose --force --install

%configure --disable-static \
	   --enable-html-doc \
	   --with-docbook-xsl=%_datadir/xml/docbook/xsl-stylesheets \
           --enable-show-failed-test-output

%make

%install
%makeinstall


%files
%_bindir/fix-qdf
%_bindir/qpdf
%_bindir/zlib-flate
%_mandir/man1/*

%files -n lib%name
%doc README TODO ChangeLog Artistic-2.0
%_libdir/libqpdf*.so.*

%files -n lib%name-devel
%doc examples/*.cc examples/*.c
%_includedir/*
%_libdir/libqpdf*.so
%_libdir/pkgconfig/libqpdf.pc

%files doc
%doc doc/qpdf-manual.html doc/stylesheet.css

%changelog
