%def_without python
%def_without python-qt3

%define suff 6
%define oname qscintilla2
Summary: QScintilla is a port to Qt of Neil Hodgson's Scintilla C++ editor class
Name: %oname-%suff
Version: 2.5.1
Release: alt4
License: GPL
Group: Development/KDE and QT
Source: qscintilla-gpl-%version.tar.gz
Patch: qscintilla-2.4-alt-allinone.patch

Packager: Boris Savelev <boris@altlinux.org>
Url: http://www.riverbankcomputing.co.uk/software/qscintilla/

%define libname lib%name

# Automatically added by buildreq on Sun Oct 12 2008
BuildRequires: gcc-c++ libqt3-devel libqt4-devel
BuildRequires: python-module-PyQt4-devel python-module-qt-devel
BuildRequires: python-module-sip-devel

%description
Qscintilla is a free source code editing component. It comes with complete
source code and a license that permits use in any free project or commercial
product. As well as features found in standard text editing components,
Scintilla includes features especially useful when editing and debugging
source code. These include support for syntax styling, error indicators, code
completion and call tips. The selection margin can contain markers like those
used in debuggers to indicate breakpoints and the current line. Styling
choices are more open than with many editors, allowing the use of proportional
fonts, bold and italics, multiple foreground and background colours and
multiple fonts.

%package -n %libname-qt3
Summary: QScintilla is a port to Qt of Neil Hodgson's Scintilla C++ editor class.
Group: System/Legacy libraries
Conflicts: libqscintilla
Provides: lib%name-qt3 = %version-%release
Obsoletes: lib%name-qt3
Obsoletes: lib%name-5-qt3
Obsoletes: lib%name-qt3-compat

%description -n %libname-qt3
Qscintilla is a free source code editing component. It comes with complete
source code and a license that permits use in any free project or commercial
product. As well as features found in standard text editing components,
Scintilla includes features especially useful when editing and debugging
source code. These include support for syntax styling, error indicators, code
completion and call tips. The selection margin can contain markers like those
used in debuggers to indicate breakpoints and the current line. Styling
choices are more open than with many editors, allowing the use of proportional
fonts, bold and italics, multiple foreground and background colours and
multiple fonts.

%package -n %libname-qt4
Summary: QScintilla is a port to Qt of Neil Hodgson's Scintilla C++ editor class.
Group: System/Legacy libraries
Provides: lib%name-qt4 = %version-%release
Obsoletes: lib%name-qt4
Obsoletes: lib%name-5-qt4
Obsoletes: lib%name-qt4-compat

%description -n %libname-qt4
Qscintilla is a free source code editing component. It comes with complete
source code and a license that permits use in any free project or commercial
product. As well as features found in standard text editing components,
Scintilla includes features especially useful when editing and debugging
source code. These include support for syntax styling, error indicators, code
completion and call tips. The selection margin can contain markers like those
used in debuggers to indicate breakpoints and the current line. Styling
choices are more open than with many editors, allowing the use of proportional
fonts, bold and italics, multiple foreground and background colours and
multiple fonts.

%package -n lib%name-qt3-devel
Requires: %libname-qt3 = %version-%release
Requires: libqt3-devel
Summary: Header files for %name
Group: Development/KDE and QT

%description -n lib%name-qt3-devel
Header files for %name

%package -n lib%name-qt4-devel
Requires: %libname-qt4 = %version-%release
Requires: libqt4-devel
Summary: Header files for %name
Group: Development/KDE and QT

%description -n lib%name-qt4-devel
Header files for %name

%package -n lib%name-qt3-designer
Requires: %libname-qt3 = %version-%release
Summary: QScintilla designer plugin
Group: Development/KDE and QT

%description -n lib%name-qt3-designer
QScintillla designer plugin.

%package -n lib%name-qt4-designer
Requires: %libname-qt4 = %version-%release
Summary: QScintilla designer plugin
Group: Development/KDE and QT

%description -n lib%name-qt4-designer
QScintillla designer plugin.

%if_with python
%package -n python-module-%name-qt4
Requires: %libname-qt4 = %version-%release
Summary: Python bindings for %name
Group: Development/KDE and QT
Provides: lib%name-qt4-python = %version-%release
Obsoletes: lib%name-qt4-python

%description -n python-module-%name-qt4
Python bindings for %name

%package -n python-module-%name-qt4-devel
Requires: python-module-%name-qt4 = %version-%release
Summary: Python bindings for %name
Group: Development/KDE and QT
BuildArch: noarch
Provides: lib%name-qt4-python-devel = %version-%release
Obsoletes: lib%name-qt4-python-devel

%description -n python-module-%name-qt4-devel
Devel files for Python bindings for %name

%if_with python-qt3
%package -n python-module-%name-qt3
Requires: %libname-qt3 = %version-%release
Summary: Python bindings for %name
Group: Development/KDE and QT
Provides: lib%name-qt3-python = %version-%release
Obsoletes: lib%name-qt3-python

%description -n python-module-%name-qt3
Python bindings for %name

%package -n python-module-%name-qt3-devel
Requires: python-module-%name-qt3 = %version-%release
Summary: Python bindings for %name
Group: Development/KDE and QT
BuildArch: noarch
Provides: lib%name-qt3-python-devel = %version-%release
Obsoletes: lib%name-qt3-python-devel

%description -n python-module-%name-qt3-devel
Devel files for Python bindings for %name
%endif
%endif

%package -n %libname-doc
Summary: Documentation for %name
Group: Development/KDE and QT
BuildArch: noarch

%description -n %libname-doc
Documentation for %name

%prep
%setup -n QScintilla-gpl-%version
%patch0 -p2
cp -a Python Python-qt4
%if_with python-qt3
mv Python Python-qt3
%endif

%build

forDebug() {
	# around of bug in /usr/lib/rpm/debugedit
	sed -i 's|\(QTDIR)\)/|\1|g' Makefile
}

# Qt3
pushd Qt3
qmake-qt3 QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" qscintilla.pro
forDebug
%make_build
popd

# Designer for Qt3
#pushd designer-Qt3
#qmake-qt3 QMAKE_CFLAGS_RELEASE="%optflags" \
#	QMAKE_CXXFLAGS_RELEASE="%optflags" designer.pro
#forDebug
#make_build
#popd

# Qt4
pushd Qt4
qmake-qt4 QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" qscintilla.pro
forDebug
%make_build
popd

# Designer for Qt4
#pushd designer-Qt4
#qmake-qt4 QMAKE_CFLAGS_RELEASE="%optflags" \
#	QMAKE_CXXFLAGS_RELEASE="%optflags" designer.pro
#forDebug
#make_build
#popd

%if_with python
# Python bindings
%if_with python-qt3
pushd Python-qt3
python configure.py -p 3 -n ../Qt3 -o ../Qt3
STR=`cat Makefile | grep "LFLAGS ="`
# add rpath for use qt3 %name lib
sed -i "s:$STR:$STR,-rpath,%_qt3dir/lib:g" Makefile
%make
popd
%endif

# Python bindings for PyQt4
pushd Python-qt4
python configure.py --debug -p 4 -n ../Qt4 -o ../Qt4
%make_build
popd
%endif

%install
%if_with python
# Python bindings
%if_with python-qt3
pushd Python-qt3
%makeinstall_std
mv %buildroot%python_sitelibdir/PyQt4/qsci.so %buildroot%python_sitelibdir
popd
%endif

# Python bindings for PyQt4
pushd Python-qt4
%makeinstall_std
popd
%endif

mkdir -p %buildroot%python_sitelibdir/PyQt4
mkdir -p %buildroot%_includedir/qt4/Qsci
mkdir -p %buildroot%_qt3dir/include/Qsci
mkdir -p %buildroot%_libdir/{qt3,qt4}/{lib,translations,plugins/designer}
mkdir -p %buildroot%_datadir/sip/qsci
mkdir -p %buildroot%_datadir/{qt3,qt4}/qsci/api/python

# Qt3 library
install Qt3/lib%oname.so.*.*.* %buildroot%_qt3dir/lib
install Qt3/*.qm %buildroot%_qt3dir/translations
pushd %buildroot%_qt3dir/lib
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]$//`
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]\.[0-9]$//`
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]\.[0-9]\.[0-9]$//`
popd

# Qt4 library
install Qt4/lib%oname.so.*.*.* %buildroot%_libdir
install Qt4/*.qm %buildroot%_qt4dir/translations
pushd %buildroot%_libdir
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]$//`
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]\.[0-9]$//`
ln -s lib%oname.so.*.*.* `ls lib%oname.so.*.*.* | sed s/\.[0-9]\.[0-9]\.[0-9]$//`
popd
pushd %buildroot%_qt4dir/lib
for libname in ../../lib%oname.*; do
ln -s $libname ./
done
popd

# Qt3 designer
#install designer-Qt3/libqscintillaplugin.so %buildroot%_qt3dir/plugins/designer

# Qt4 designer
#install designer-Qt4/libqscintillaplugin.so %buildroot%_qt4dir/plugins/designer

# Qt3 headers
#install -m644 Qt3/*.h %buildroot%_qt3dir/include
#install -m644 Qt3/Qsci/*.h %buildroot%_qt3dir/include/Qsci

# Qt4 headers
#install -m644 Qt4/*.h %buildroot%_includedir/qt4
#install -m644 Qt4/Qsci/*.h %buildroot%_includedir/qt4/Qsci

# docs
#mkdir -p %buildroot%_docdir/%libname-%version
#cp -a doc/Scintilla %buildroot%_docdir/%libname-%version
#cp -a doc/html-Qt3 %buildroot%_docdir/%libname-%version
#cp -a doc/html-Qt4 %buildroot%_docdir/%libname-%version

%files -n %libname-qt3
%_qt3dir/lib/*.so.*
%_qt3dir/translations/*

%files -n %libname-qt4
%_qt4dir/lib/*.so.*
%_libdir/*.so.*
#_qt4dir/translations/*

#files -n lib%name-qt3-devel
#_qt3dir/include/*.h
#_qt3dir/include/Qsci
#_qt3dir/lib/*.so

#files -n lib%name-qt4-devel
#_includedir/qt4/*.h
#_includedir/qt4/Qsci
#_qt4dir/lib/*.so
#_libdir/*.so

#files -n lib%name-qt3-designer
#_qt3dir/plugins/designer/*.so

#files -n lib%name-qt4-designer
#_qt4dir/plugins/designer/*.so

%if_with python
%if_with python-qt3
%files -n python-module-%name-qt3
%python_sitelibdir/qsci.so
%_qt3dir/qsci

%files -n python-module-%name-qt3-devel
%_datadir/sip/qsci
%endif

%files -n python-module-%name-qt4
%python_sitelibdir/PyQt4/Qsci.so
%_datadir/qt4/qsci/api/python/*.api

%files -n python-module-%name-qt4-devel
%_datadir/sip/PyQt4/Qsci
%endif

#files -n %libname-doc
#_docdir/%libname-%version

%changelog
