%add_findreq_skiplist *gdbmacros*
%add_python_req_skip lldb

Name: qt-creator
Version: 3.0.1
Release: alt0.M70P.1
Summary: Lightweight and cross-platform IDE for Qt

Group: Development/Tools
License: LGPLv2 with exceptions
Url: http://qt.nokia.com/products/developer-tools
Packager: Anatoly Lyutin <vostok@altlinux.org>

#Source: http://download.qtsoftware.com/qtcreator/%name-%version-src.tar.gz
Source: %name-%version.tar
Source1: qtcreator.desktop

Patch: %name-%version-%release.patch

Requires: %name-data = %version-%release

BuildRequires: gcc-c++ 
BuildRequires: libqt4-devel >= 4.8.0
BuildRequires: libqt4-webkit >= 4.8.0

%description
Qt Creator (previously known as Project Greenhouse) is a new,
lightweight, cross-platform integrated  development environment (IDE)
designed to make development with the Qt application framework
even faster and easier.

%package doc
Summary: %name docs
Group: Documentation
BuildArch: noarch
Requires: %name
Requires: libqt4-sql-sqlite

%description doc
Documentation for %name

%package data
Summary: Data files for %name
Group: Development/Tools
BuildArch: noarch
Requires: %name

%description data
Data files for %name

%prep
%setup
subst 's,tools\/qdoc3,bin,' doc/doc.pri
subst 's,share\/doc\/qtcreator,share\/qtcreator\/doc,' doc/doc.pri src/plugins/help/helpplugin.cpp
%patch -p1

%build
export QTDIR=%_qt4dir
qmake-qt4 IDE_LIBRARY_BASENAME=%_lib
NPROCS=1
%make_build
%make_build docs

%install
%makeinstall_std INSTALL_ROOT=%buildroot%_prefix
mkdir -p %buildroot%_desktopdir
install %SOURCE1 %buildroot%_desktopdir

mkdir -p %buildroot%_datadir/qtcreator/translations
cp share/qtcreator/translations/*.qm %buildroot%_datadir/qtcreator/translations

for i in 16 24 32 48 64 128 256 512; do
    install -pD -m644 src/plugins/coreplugin/images/logo/${i}/QtProject-qtcreator.png \
                      %buildroot%_iconsdir/hicolor/${i}x${i}/apps/QtProject-qtcreator.png
#    mkdir -p %buildroot%_iconsdir/hicolor/${i}x${i}/apps
#    ln -s %_pixmapsdir/qtcreator_logo_${i}.png \
#          %buildroot%_iconsdir/hicolor/${i}x${i}/apps/%name.png
done
%make_install INSTALL_ROOT=%buildroot%_prefix install_docs

%files
%doc README LICENSE.LGPL LGPL_EXCEPTION.TXT
%_bindir/*
%_libdir/qtcreator
%_iconsdir/hicolor/*/apps/QtProject-qtcreator.png
%_desktopdir/qtcreator.desktop

%files doc
%_datadir/qtcreator/doc

%files data
%dir %_datadir/qtcreator/translations
%dir %_datadir/qtcreator
%_datadir/qtcreator/*
%exclude %_datadir/qtcreator/doc

%changelog
