#Determint whether to use system-wide liborigin or builtin
%def_with liborigin
%def_with new_sip

Name: qtiplot
Version: 0.9.8.9
Release: alt2.svn20120124

Summary: WYSIWYG tool to make two- and three-dimensional plots of scientific data
Group: Sciences/Other
License: GPL
Url: http://soft.proindependent.com/%name.html
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%define pkgdocdir %_docdir/%name-%version

# http://svn.berlios.de/svnroot/repos/qtiplot/trunk
Source: %name-%version.tar.bz2
Source1: %name.xml
Source2: %name.png
Source3: %name.desktop
Source4: faq.html
Source5: help.html
Source6: colormaps.tar.gz
Source7: %{name}_ru.ts
Source8: build.conf

Patch3: %name-0.9.7.8-alt-docbook_stylesheet.patch
Patch5: %name-0.9.7.8-alt-boostincludes.patch
Patch6: %name-0.9.7.8-alt-sip_kludge.patch

BuildPreReq: texlive-latex-extra

# Automatically added by buildreq on Sun Feb 03 2008
BuildRequires: gcc-c++ libgsl-devel libmuparser-devel libqt4-devel
BuildRequires: python-module-PyQt4-devel python-module-sip-devel
BuildRequires: docbook-utils docbook-style-dsssl dblatex boost-devel
BuildRequires: doxygen boost-datetime-devel libpng-devel
BuildRequires: desktop-file-utils shared-mime-info >= 0.15-alt2
BuildRequires: libqtexengine-devel
%if_with liborigin
BuildRequires: liborigin2-devel
%endif
%if_with new_sip
BuildRequires: python-module-sip-devel >= 4.7.9
%endif
BuildRequires: python-modules-multiprocessing libqt4-assistant-devel

Requires: %name-data = %version-%release
Requires: %name-manual-html = %version-%release

Provides: python%_python_version(qti)

%description
qtiplot is a program for scientific data visualizing. It can produce
two- and three-dimensional graphics and diagrams and export them to
various graphics formats. It also can make some kind of data processing.

%package data
Summary: Data files for QtiPlot
Group: Sciences/Other
BuildArch: noarch
Requires: %name = %version-%release

%description data
qtiplot is a program for scientific data visualizing. It can produce
two- and three-dimensional graphics and diagrams and export them to
various graphics formats. It also can make some kind of data processing.

This package contains data files for QtiPlot.

%package -n %name-manual-html

Summary: Manual for QtiPlot program
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description -n %name-manual-html
This package contains manual for QtiPlot, the program for scientific
data manipulation and visualization. The manual is in HTML format.

Requires: %name
Obsoletes: %name-manual
Conflicts: %name-manual

%package -n %name-manual-pdf

Summary: Manual for QtiPlot program
Group: Documentation
BuildArch: noarch

%description -n %name-manual-pdf
This package contains manual for QtiPlot, the program for scientific
data manipulation and visualization. The manual is in PDF format.

Requires: %name
Obsoletes: %name-manual
Conflicts: %name-manual

%prep
%setup

%patch3 -p1

subst "s/lupdate/lupdate-qt4/;s/lrelease/lrelease-qt4/;\
s/#system(lupdate/system(lupdate/;s/#system(lrelease/system(lrelease/" \
	%name/%name.pro
sed -i "s|/usr/local|%_libdir|" %name/%name.pro
sed -i "s|/lib|/%_lib|g" 3rdparty/qwt/qwtconfig.pri
sed -i 's|@VERSION@|%version|' qtiplot/qtiplot.pro

find . -type f -name '*.pro' | while read FILE; do
    echo "QMAKE_CXXFLAGS_RELEASE = %optflags -fno-strict-aliasing" >> "$FILE"
    echo "QMAKE_CFLAGS_RELEASE = %optflags -fno-strict-aliasing" >> "$FILE"; done
#cp -f %SOURCE7 %name/translations/

install -m644 %SOURCE8 .

%build
mkdir -p tmp/qtiplot
export QTI_ROOT=$PWD
qmake-qt4 %name.pro
%make

pushd qtiplot/translations
%_qt4dir/bin/lrelease *.ts
popd

%install
make install INSTALL_ROOT=%buildroot
install -pD -m644 %SOURCE2 %buildroot%_niconsdir/%name.png
mkdir -p %buildroot%_pixmapsdir
ln -s %_niconsdir/%name.png %buildroot%_pixmapsdir/%name.png

install -pD -m644 %SOURCE3 %buildroot%_desktopdir/%name.desktop

mkdir -p %buildroot%_datadir/%name/translations
cp %name/translations/*.qm %buildroot%_datadir/%name/translations

mkdir -p %buildroot%pkgdocdir/manual
install -pD -m644 {%SOURCE4,%SOURCE5} %buildroot%pkgdocdir
mkdir -p %buildroot%_man1dir
install -pD -m644 %name.1 %buildroot%_man1dir

tar xzvf %SOURCE6 -C $RPM_BUILD_ROOT%_datadir/%name

#mv -f %buildroot%_docdir/%name/manual %buildroot%pkgdocdir/
install -p -m644 manual/%name-manual-en.pdf %buildroot%pkgdocdir/manual

install -pD -m644 %SOURCE1  %buildroot%_datadir/mime/packages/%name.xml

install -d %buildroot%_bindir
install -m755 %name/%name %buildroot%_bindir
install -m644 %name/qti*.py %name/*.txt %buildroot%_libdir/%name
chmod 644 %buildroot%_libdir/%name/*.txt

%ifarch x86_64
install -d %buildroot%_libdir/%name/plugins
mv %buildroot%_libexecdir/%name/plugins/* \
	%buildroot%_libdir/%name/plugins/
%endif

%files
%dir %_datadir/%name
%dir %pkgdocdir
%dir %pkgdocdir/manual
%pkgdocdir/*.html
%_bindir/*
%_niconsdir/*
%dir %_libdir/%name
%_libdir/%name/plugins
%_libdir/%name/*.py
%_libdir/%name/*.pyc
%_libdir/%name/*.txt
%_pixmapsdir/*
%_desktopdir/*
%_man1dir/*
%_datadir/mime/packages/*
%exclude %_includedir
%exclude %_libdir/*.a
%exclude %_libdir/%name/*.pyo
%exclude %_libdir/%name/qtiplot_remote_ctl.py*
%exclude %_docdir/%name
%exclude %prefix/src

%files data
%_datadir/%name/*

%files -n %name-manual-html
%pkgdocdir/manual/html

%files -n %name-manual-pdf
%pkgdocdir/manual/*.pdf

%changelog
