# spec file for package qupzilla
# Original author: Mariusz Fik (Fisiu)
# Copyright (c) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself.

Name: qupzilla
Version: 1.8.9
Release: alt0.M70T.1

Summary: A very fast open source browser based on WebKit core
License: GPLv3+
Group: Networking/WWW

Url: http://qupzilla.com
# https://github.com/QupZilla/qupzilla
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Tue Mar 13 2012
# optimized out: fontconfig libgst-plugins libqt4-core libqt4-dbus libqt4-devel libqt4-gui libqt4-network libqt4-script libqt4-sql libqt4-webkit libqt4-xml libstdc++-devel
BuildRequires: gcc-c++ phonon-devel

BuildRequires: libqt4-devel >= 4.7
BuildRequires: gdb

Requires: libqt4-sql-sqlite

%description
QupZilla is a new and very fast World Wide Web Browser
which uses Qt Framework and its QtWebKit rendering core.
It is a lightweight browser with some advanced functions
like integrated AdBlock, Search Engines Manager, Theming
support, Speed Dial and SSL Certificate manager.

%prep
%setup

%build
export USE_WEBGL="true"
export NONBLOCK_JS_DIALOGS="true"
export KDE="false"
export USE_LIBPATH="%_libdir"
echo "CONFIG += debug" >> src/defines.pri
qmake-qt4
%make_build

%install
make INSTALL_ROOT=%buildroot install

%files
%doc AUTHORS FAQ
%_bindir/%name
%_libdir/%name
%_libdir/*.so.*
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_iconsdir/hicolor/*/*/*.png
%dir %_datadir/%name
%_datadir/%name/locale
%exclude %_datadir/%name/locale/uz@Latn.qm
%_datadir/%name/themes
%_datadir/bash-completion/completions/qupzilla
%_datadir/appdata/*

# TODO:
# - move shared libraries to a subpackage?

%changelog
