# This spec is backported to ALTLinux p7 automatically by rpmbph script. Do not edit it.
#
%define _unpackaged_files_terminate_build 1
%add_erlang_req_modules_skiplist bad

%define oname rabbitmq

Name: rabbitmq-server
Version: 2.8.7
Release: alt3.M70P.4
License: MPLv1.1
BuildArch: noarch
Group: System/Servers
Source: %name-%version.tar
Source1: rabbitmq-server.service
Source2: rabbitmq-script-wrapper
Source3: rabbitmq-server.logrotate
Source4: rabbitmq-env.conf
Source5: include.mk
Source6: rabbitmq-server.init
URL: http://www.rabbitmq.com/
Packager: Maxim Ivanov <redbaron@altlinux.org>


BuildRequires(pre): rpm-build-erlang
BuildRequires: erlang-devel
BuildRequires: python-module-simplejson
BuildRequires: erlang-otp-devel
BuildRequires: xmlto
BuildRequires: zip
BuildRequires: unzip
Requires: erlang
Summary: The RabbitMQ server

%description
RabbitMQ is an implementation of AMQP, the emerging standard for high
performance enterprise messaging. The RabbitMQ server is a robust and
scalable implementation of an AMQP broker.

%package -n %name-devel
Summary: %name header files
License: MPLv1.1
Group: Development/Erlang

%description -n %name-devel
Erlang header files for %name

%prep
%setup -q

%build
sed -i 's|@libexecdir@|%_libexecdir|g' %SOURCE2
sed -i 's|@localstatedir@|%_localstatedir|g' %SOURCE2
sed -i 's|@RABBITMQ_DIR@|%_erllibdir/%name|g' %SOURCE5
%make_build

%install
%make_install TARGET_DIR=%buildroot%_erllibdir/%name \
        SBIN_DIR=%buildroot%_libexecdir/%oname \
        MAN_DIR=%buildroot%_mandir \
        install

mkdir -p %buildroot%_localstatedir/%oname/mnesia
mkdir -p %buildroot%_logdir/%oname

#Copy all necessary lib files etc.
install -p -D -m 0755 %SOURCE1 %buildroot%_unitdir/%oname.service
install -p -D -m 0755 %SOURCE2 %buildroot%_sbindir/rabbitmqctl
install -p -D -m 0755 %SOURCE2 %buildroot%_sbindir/%name

install -p -D -m 0644 %SOURCE3 %buildroot%_logrotatedir/%name
install -p -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/%oname/%oname.conf

install -p -D -m 0644 %SOURCE5 %buildroot%_datadir/%name/include.mk
#Sysvinit support
install -p -D -m 0755 %SOURCE6 %buildroot%_initrddir/%oname

mkdir -p %buildroot%_sysconfdir/%oname/conf.d
rm %buildroot%_erllibdir/%name/{LICENSE,LICENSE-MPL-RabbitMQ,INSTALL}

mkdir -p %buildroot/%_erlanglibdir/%name/priv

%pre
%_sbindir/groupadd -r -f rabbitmq &>/dev/null
%_sbindir/useradd -r -g rabbitmq  -d %_localstatedir/rabbitmq -s /dev/null \
   -c 'RabbitMQ messaging server' -M -n rabbitmq &>/dev/null ||:

%post
%post_service %oname

%preun
%preun_service %oname

%files
%_sbindir/*
%_libexecdir/%oname
%_erlanglibdir/%name
%exclude %_erlanglibdir/%name/include
%attr(0750, rabbitmq, rabbitmq) %dir %_localstatedir/%oname
%attr(0750, rabbitmq, rabbitmq) %dir %_logdir/%oname
%config(noreplace) %_logrotatedir/*
%config(noreplace) %_sysconfdir/%oname
%_man1dir/*
%_man5dir/*
%_unitdir/%oname.service
%_initrddir/%oname
%doc LICENSE LICENSE-MPL-RabbitMQ README INSTALL

%files -n %name-devel
%_erlanglibdir/%name/include
%_datadir/%name

%changelog
