%define _pseudouser_user     _radvd
%define _pseudouser_group    _radvd
%define _pseudouser_home     %_localstatedir/radvd

Name: radvd
Version: 1.15
Release: alt1.M70P.1

Summary: A Router Advertisement daemon
# The code includes the advertising clause, so it's GPL-incompatible
License: BSD with advertising
Group: System/Servers

Url: http://www.litech.org/radvd/
# git://github.com/reubenhwk/radvd.git
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Source3: %name-tmpfs.conf
Source4: %name.service

BuildRequires: libdaemon-devel
BuildRequires: flex, byacc

%description
radvd is the router advertisement daemon for IPv6.  It listens to router
solicitations and sends router advertisements as described in "Neighbor
Discovery for IP Version 6 (IPv6)" (RFC 2461).  With these advertisements
hosts can automatically configure their addresses and some other
parameters.  They also can choose a default router based on these
advertisements.

Install radvd if you are setting up IPv6 network and/or Mobile IPv6
services.

%prep
%setup

%build
%autoreconf
%configure --with-pidfile=/var/run/radvd/radvd.pid
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_initdir
mkdir -p %buildroot/var/run/radvd

install -m 644 redhat/radvd.conf.empty %buildroot%_sysconfdir/radvd.conf
install -m 755 %SOURCE1 %buildroot%_initdir/radvd
install -m 644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/radvd
install -Dm0644 %SOURCE3 %buildroot%_sysconfdir/tmpfiles.d/%name.conf
install -Dm0644 %SOURCE4 %buildroot%systemd_unitdir/%name.service

%post
%post_service %name

%preun
%preun_service %name

%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'radvd user' \
        -d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%files
%doc COPYRIGHT README CHANGES-1 INTRO.html TODO
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_sysconfdir/tmpfiles.d/%name.conf
%config %systemd_unitdir/%name.service
%_initdir/%name
%dir %attr(0771,root,%_pseudouser_group) /var/run/radvd/
%doc radvd.conf.example
%_mandir/*/*
%_sbindir/radvd
%_sbindir/radvdump

%changelog
