%define beta %nil
%def_disable static

Name: recode
Version: 3.6
Release: alt11

Summary: The `recode' library converts files between character sets and usages
License: GPL
Group: Text tools

Url: http://recode.progiciels-bpi.ca
Source: %url/archives/%name-%version%beta.tar.gz
Patch0: recode4python.patch
Patch1: recode-3.6-debian-boolsize.patch
Packager: Michael Shigorin <mike@altlinux.org>

Requires: lib%name = %version-%release
BuildRequires: chrpath

Summary(ru_RU.KOI8-R):  recode     

%description
The `recode' program is a handy front-end to the `recode' library;
it converts files between character sets and usages.

The `recode' program and library have been written by Francois Pinard.
It is an evolving package, and specifications might change in future
releases.  Option `-f' is now fairly implemented, yet not fully.

%package -n lib%name
Summary: Recode library
Group: System/Libraries

%description -n lib%name
The `recode' library converts files between character sets and usages.
The library recognises or produces nearly 150 different character sets
and is able to transliterate files between almost any pair.  When
exact transliteration are not possible, it may get rid of the
offending characters or fall back on approximations.  Most RFC 1345
character sets are supported.

%package -n lib%name-devel
Summary: Headers for developing applications with `recode' library
Group: Development/Other
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 3.6-alt7

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop applications using the `recode' libraries.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static library for developing applications with `recode' library
Group: Development/Other
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package provides the necessary development libraries and include
files to allow you to develop applications using the `recode' libraries.
%endif

%prep
%setup -n %name-%version%beta
#patch0 -p1
%patch1 -p1

%build
rm acinclude.m4 m4/libtool.m4 m4/flex.m4
sed -i 's/ad_AC_PROG_FLEX/AC_PROG_LEX/' configure.in
%autoreconf
sed -i 's/--no-verify//' configure
%configure %{subst_enable static}
%make_build

%install
%makeinstall
%find_lang %name
chrpath -d %buildroot%_bindir/%name

%files -f %name.lang
%_bindir/*
%_infodir/*
%_man1dir/*
%doc ABOUT-NLS AUTHORS BACKLOG COPYING COPYING-LIB ChangeLog INSTALL THANKS TODO

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

# TODO:
# - keep an eye on 3.7 (now in beta) and eventually 4.0

%changelog
