%def_with inotify
%def_with fam
%define pre %nil

Name: recoll
Version: 1.18.1
Release: alt1

Summary: A personal full text search package
License: %gpl2plus
Group: File tools

Url: http://www.recoll.org
Source0: %url/%name-%version%pre.tar.gz
Source1: recoll_ru.ts
Source2: recoll_ru.qm
Source3: recoll_uk.ts
Source4: recoll_uk.qm
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: gcc-c++ libqt4-devel qt4-settings libXt-devel libaspell-devel xorg-cf-files ImageMagick
%{?_with_fam:BuildRequires: libfam-devel}
BuildRequires: libxapian-devel >= 0.9
BuildRequires: rpm-build-licenses
BuildRequires: perl-Image-ExifTool
BuildRequires: python-devel

%add_findreq_skiplist %_datadir/%name/examples/*

%description
Recoll is a personal full text search package based on a very strong
backend (Xapian), for which it provides an easy to use, feature-rich,
easy administration interface.

See also recoll-extras package for somewhat more exotic stuff.

%package extras
Summary: More helper scripts for Recoll
Group: File tools
Requires: %name = %version
BuildArch: noarch

%description extras
This package contains additional helper scripts for recoll which might
need bulky additional required packages, manual setup, or both.

%package full
Summary: All the recommended stuff for Recoll
Group: File tools
BuildArch: noarch
Requires: %name = %version
Requires: perl-Image-ExifTool
Requires: antiword catdoc unrtf
Requires: python-module-pychm
Requires: aspell aspell-ru-rk
Requires: xpdf-utils ghostscript-utils

%description full
This package contains just the requirements for additional packages
that might be of use with Recoll.

%prep
%setup -n %name-%version%pre
subst 's/openoffice/ooffice/' sampleconf/mimeview
subst '/^Categories=/s/=/=Qt;/' desktop/*.desktop
# updated translations
#cp -a %SOURCE1 %SOURCE2 qtgui/i18n/	# ru
#cp -a %SOURCE3 %SOURCE4 qtgui/i18n/	# uk

%build
export CXXFLAGS="%optflags" PATH="$PATH:%_libdir/qt4/bin"
%configure %{subst_with inotify} %{subst_with fam}
%make_build
bzip2 --best --keep --force ChangeLog
for s in 128 96 72 64 36 32 24 22 16; do
    convert -depth 8 -resize ${s}x$s desktop/%name{.xcf,-$s.png}
done

%install
%makeinstall_std
for s in 128 96 72 64 36 32 24 22 16; do
    install -pDm644 desktop/%name-$s.png %buildroot%_iconsdir/hicolor/${s}x$s/apps/%name.png
done
sed -i 's/xterm/xvt/g' %buildroot%_datadir/%name/filters/*

# KDE+GNOME+whatever
%add_findreq_skiplist %_datadir/%name/filters/xdg-open

%files
%_bindir/*
%_datadir/%name
%exclude %_datadir/%name/filters/rcllyx
%exclude %_datadir/%name/filters/hotrecoll.py
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_desktopdir/*
%_man1dir/*
%_man5dir/*
%doc ChangeLog.* README

%files extras
%_datadir/%name/filters/rcllyx
%_datadir/%name/filters/hotrecoll.py

%files full

# TODO:
# - consider packaging python bits
#  ("small recoll integration and extension hacks")

%changelog
