%def_without geogclue2

Name: 	 redshift
Version: 1.10
Release: alt1.M70P.1

Summary: Redshift adjusts the color temperature of your screen
Summary(ru_RU.UTF-8): Redshift изменяет температуру цвета вашего экрана для снижения утомляемости глаз

License: GPLv3+
Group: 	 Graphical desktop/GNOME
Url: 	 http://jonls.dk/redshift/
#VCS:    https://github.com/jonls/redshift.git

Packager: Anton Chernyshov <ach@altlinux.org>
Source0:  %name-%version.tar

Patch1:   %name-geoclue-provider.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-gir
BuildPreReq: libGConf-devel
BuildPreReq: libXrandr-devel
BuildPreReq: libXxf86vm-devel
BuildPreReq: libgeoclue-devel
%if_with geoclue2
BuildPreReq: libgio-devel
BuildPreReq: geoclue2-devel
%endif
BuildPreReq: gettext-devel
BuildRequires: libdrm-devel
BuildRequires: python3-module-pygobject
BuildRequires: python3-module-pyxdg
BuildRequires: systemd-devel
BuildRequires: intltool

# libaptindicator is not package in ALT Linux
%add_typelib_req_skiplist typelib(AppIndicator3)

%description
Redshift adjusts the color temperature of your screen according
to your surroundings. This may help your eyes hurt less if you
are working in front of the screen at night. The color temperature
is set according to the position of the sun. A different color
temperature is set during night and daytime. During twilight and early
morning, the color temperature transitions smoothly from night
to daytime temperature to allow your eyes to slowly adapt.

%description -l ru_RU.UTF-8
Redshift изменяет температуру цвета экрана вашего компьютера. Это может
снизить утомляемость глаз, особенно если вы работаете за компьютером
ночью. Температура цвета устанавливается в зависимости от позиции
солнца на небе (определяется на основе географических координат)
и текущего времени суток. Изменение температуры цвета происходит
плавно, давая Вашим глазам время на адаптацию.

%prep
%setup
sed -i -e 's|AC_PREREQ(\[2.69\])|AC_PREREQ([2.68])|' configure.ac
%patch1 -p1
%autoreconf

%build
%configure \
    --enable-drm \
    --enable-randr \
    --enable-vidmode \
    --enable-nls \
    --enable-gui \
    --enable-gnome-clock \
    --enable-geoclue \
%if_with geoclue2
    --enable-geoclue2 \
%endif


%make_build

%install
%makeinstall_std
test %_libdir = /usr/lib64 && mv %buildroot/%_libexecdir %buildroot/%_libdir
%find_lang %name

%files -f %name.lang
%doc COPYING DESIGN NEWS README README-colorramp
%_bindir/*
%python3_sitelibdir/%{name}_gtk/*
%_libdir/systemd/user/%{name}*
%_desktopdir/*
%_iconsdir/hicolor/*
%doc %_man1dir/*
%_datadir/appdata/redshift-gtk.appdata.xml

%post
# If gnome-panel installed (i.e for GNOME users) - set program to autostart
# KDE users must set redshift parameters manually
if [ -e %_desktopdir/gnome-panel.desktop ]; then
	cp %_desktopdir/gtk-redshift.desktop %_sysconfdir/xdg/autostart/
fi

%postun
rm -f %_sysconfdir/xdg/autostart/gtk-redshift.desktop

%changelog
