Name: refind
Version: 0.6.12
Release: alt3

Summary: EFI boot manager software
License: GPLv3
Group: System/Base

Url: http://www.rodsbooks.com/refind/
Source: refind-src-%version.zip
Source1: altlinux_altinst.icns
Source2: altlinux_live.icns
Source3: altlinux_rescue.icns
Patch: 0001-Support-for-memtest86-as-a-second-row-item.patch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: gnu-efi-3.0r
BuildRequires: unzip
BuildRequires: rpm-macros-uefi
BuildRequires: pesign >= 0.109-alt4
Requires: efibootmgr
Obsoletes: refind-signed

ExclusiveArch: x86_64

%define refind_lib %_efi_bindir
%define refind_data %_datadir/%name

%description
A graphical boot manager for EFI- and UEFI-based computers, such as all
Intel-based Macs and recent (most 2011 and later) PCs. rEFInd presents a
boot menu showing all the EFI boot loaders on the EFI-accessible
partitions, and optionally BIOS-bootable partitions on Macs. EFI-compatbile
OSes, including Linux, provide boot loaders that rEFInd can detect and
launch. rEFInd can launch Linux EFI boot loaders such as ELILO, GRUB
Legacy, GRUB 2, and 3.3.0 and later kernels with EFI stub support. EFI
filesystem drivers for ext2/3/4fs, ReiserFS, HFS+, and ISO-9660 enable
rEFInd to read boot loaders from these filesystems, too. rEFInd's ability
to detect boot loaders at runtime makes it very easy to use, particularly
when paired with Linux kernels that provide EFI stub support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%prep
%setup
%patch -p1

%build
make gnuefi
make fs_gnuefi

%install
mkdir -p %buildroot{%refind_lib{,/drivers_%_efi_arch},%refind_data}

%ifarch x86_64
# don't feed macros with complicated expressions, esp. in the loop
for i in refind/refind*.efi drivers_%_efi_arch/*_x64.efi; do
	%pesign -s -i $i
done
%endif

install -pm644 refind/refind*.efi %buildroot%refind_lib/
cp -a drivers_%_efi_arch/*.efi %buildroot%refind_lib/drivers_%_efi_arch/

cp -a icons/ %buildroot%refind_data/
install -pDm644 %SOURCE1 %buildroot%refind_data/icons/altlinux/altinst.icns
install -pDm644 %SOURCE2 %buildroot%refind_data/icons/altlinux/live.icns
install -pDm644 %SOURCE3 %buildroot%refind_data/icons/altlinux/rescue.icns

%files
%doc docs/*
%doc NEWS.txt COPYING.txt LICENSE.txt README.txt CREDITS.txt
%doc install.sh mkrlconf.sh mvrefind.sh
%refind_lib
%refind_data

%changelog
