Name: remmina
Version: 1.1.2
Release: alt1.M70P.1
Summary: Remote Desktop Client

Group: Networking/Remote access
License: GPLv2+ and MIT
Url: http://remmina.sourceforge.net
Source: %name-%version.tar

Requires: icon-theme-hicolor

BuildRequires: cmake desktop-file-utils intltool libavahi-ui-devel libgcrypt-devel libssh-devel libunique-devel libvte3-devel libavahi-ui-gtk3-devel libpng-devel libpixman-devel xorg-glproto-devel xorg-dri2proto-devel libXau-devel libXdmcp-devel libXext-devel libXdamage-devel libXxf86vm-devel libxkbfile-devel libtelepathy-glib-devel
BuildRequires: libfreerdp-devel gettext libgnome-keyring-devel libgnutls-devel libXxf86misc-devel libXv-devel libXrandr-devel libXpm-devel libXinerama-devel
BuildRequires: libjpeg-devel libtasn1-devel libp11-kit-devel libvncserver-devel

%description
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny netbooks.

Remmina supports multiple network protocols in an integrated and consistent
user interface. Currently RDP, VNC, XDMCP and SSH are supported

%package devel
Summary: remmina development headers
Group: Development/Other

%description devel
Files required to build plugins for remmina

%package plugins
Summary: A set of plugins for remmina
Group: Networking/Remote access
Requires: %name freerdp-plugins-standard

%description plugins
A set of plugins for %name remote desktop client

%package plugins-gnome
Summary: A set of plugins-gnome for remmina
Group: Networking/Remote access
Requires: %name-plugins

%description plugins-gnome
A set of plugins-gnome for %name remote desktop client

%prep
%setup

sed -i '/target_link_libraries/s/)/ -lgnutls)/' remmina-plugins/vnc/CMakeLists.txt

%build
%cmake	-DWITH_APPINDICATOR=OFF \
	-DWITH_TELEPATHY=OFF \
	-DCMAKE_INSTALL_LIBDIR=%_lib \
	-DREMMINA_PLUGINDIR=%_libdir/remmina/plugins
	
%make_build -C BUILD

%install
%makeinstall_std -C BUILD

mkdir -p %buildroot%_pkgconfigdir
install -p -m 644 remmina/%name.pc.in %buildroot%_pkgconfigdir/%name.pc

subst "s|@prefix@|%_prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@exec_prefix@|%_exec_prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@libdir@|%_libdir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@includedir@|%_includedir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@VERSION@|%version|g" %buildroot%_pkgconfigdir/%name.pc

%find_lang %name
%find_lang %name-plugins

%files -f %name.lang
%doc AUTHORS ChangeLog README
%_bindir/%name
%_datadir/applications/*.desktop
%_iconsdir/*/*/*/*

%files plugins -f %name-plugins.lang
%_libdir/remmina/plugins/*.so
%exclude %_libdir/remmina/plugins/remmina-plugins-gnome.so

%files plugins-gnome
%_libdir/remmina/plugins/remmina-plugins-gnome.so

%files devel
#_includedir/%name
%_pkgconfigdir/*

%changelog
