%define ver_major 3.0
%define rev %nil
%define gst_api_ver 1.0

%def_without hal
%def_with gudev
%def_with webkit
%def_enable daap
%def_enable visualizer
%def_enable grilo
%def_disable gtk_doc

Name: rhythmbox
Version: %ver_major
Release: alt1%rev

Summary: Music Management Application
License: GPL
Group: Sound
Url: http://www.gnome.org/projects/rhythmbox/

%define pkgdocdir %_docdir/%name-%version

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar

Patch: %name-3.0-alt-zeitgeist_plugin_python3_syntax.patch

%define dbus_ver 0.35
%define glib_ver 2.32.0
%define gst_ver 1.0
%define gtk_ver 3.6.0
%define mtp_ver 0.3
%define brasero_ver 0.9.1
%define soup_ver 2.26.0
%define totem_ver 2.32.0
%define udev_ver 143
%define gpod_ver 0.8
%define mx_ver 1.0.1
%define secret_ver 0.14

Requires: lib%name = %version-%release

Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: libgst-plugins%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver

%define _libexecdir %_libdir/%name
# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_compile_include %_libexecdir
BuildRequires: rpm-build-python3 python3-module-pygobject3-devel

BuildRequires(Pre): browser-plugins-npapi-devel

BuildRequires: glib2-devel >= %glib_ver
BuildRequires: intltool >= 0.40
BuildRequires: gtk-doc yelp-tools gnome-common desktop-file-utils

BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libdbus-glib-devel >= %dbus_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libsoup-gnome-devel >= %soup_ver
BuildRequires: libbrasero-devel >= %brasero_ver
BuildRequires: libtotem-pl-parser-devel >= %totem_ver
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: libgpod-devel >= %gpod_ver
BuildRequires: libmtp-devel >= %mtp_ver
BuildRequires: libICE-devel libSM-devel libsecret-devel >= %secret_ver
BuildRequires: iso-codes-devel libcheck-devel
BuildRequires: liblirc-devel libnotify-devel >= 0.7.3
BuildRequires: libjson-glib-devel libpng-devel
%{?_with_webkit:BuildRequires: libwebkitgtk3-devel}
BuildRequires: libpeas-devel libtdb-devel zlib-devel
%{?_enable_grilo:BuildRequires: libgrilo-devel}
BuildRequires: libavahi-glib-devel
BuildRequires: libdmapsharing-devel
%{?_enable_visualizer:BuildRequires: libclutter-gtk3-devel libclutter-gst2.0-devel libmx-devel >= %mx_ver}
%{?_with_hal:BuildRequires: libhal-devel}
%{?_with_gudev:BuildRequires: libgudev-devel}
BuildRequires: libgtk+3-gir-devel libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel

Provides: %name-plugins-audiocd
Provides: %name-plugins-generic-player

# python bindings are linked into rhythmbox statically
Provides: python%__python3_version(rb)
Provides: python%__python3_version(rhythmdb)

%description
Rhythmbox is an integrated music management application, supporting
a music library, multiple playlists, internet radio, and more.

%package -n lib%name
Summary: Shared Rhythmbox Library
Group: System/Libraries

%description -n lib%name
This package provides shared library needed for Rhythmbox to work

%package -n lib%name-devel
Summary: Development files for Rhythmbox library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Files needed to develop applications that manipulate Rhythmbox,
an integrated music management application.

%package devel-doc
Summary: API documentation for Rhythmbox
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description devel-doc
API documentation for Rhythmbox, an integrated music management application.

%package plugins-audioscrobbler
Summary: Audioscrobbler plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-audioscrobbler
Plugin to the Rhythmbox music manager that adds
Audioscrobbler (Last.fm) service support.

%package plugins-cd-recorder
Summary: CD recorder plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release
Requires: brasero >= %brasero_ver

%description plugins-cd-recorder
Plugin to the Rhythmbox music manager that provides
support for recording audio CDs from playlists

%package plugins-daap
Summary: DAAP plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-daap
Plugin to the Rhythmbox music manager that provides
support for DAAP Music Sharing

%package plugins-fmradio
Summary: FM radio plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-fmradio
Plugin to the Rhythmbox music manager that provides
Support for FM radio broadcasting services

%package plugins-ipod
Summary: iPod plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release
%description plugins-ipod
Plugin to the Rhythmbox music manager that adds
support for Apple iPod media player.

%package plugins-mtpdevice
Summary: MTP device plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-mtpdevice
Plugin to the Rhythmbox music manager that adds
support for MTP devices.

%package plugins-iradio
Summary: Internet Radio plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release
%description plugins-iradio
Plugin to the Rhythmbox music manager that provides
support for Internel Radio

%package plugins-lirc
Summary: LIRC plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-lirc
Plugin to the Rhythmbox music manager that adds
Linux Infrared Remote Control support.

%package plugins-mmkeys
Summary: Media Player Keys plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-mmkeys
Plugin to the Rhythmbox music manager that provides
control Rhythmbox using key shortcuts

%package plugins-power-manager
Summary: Power Manager plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-power-manager
Plugin to the Rhythmbox music manager that provides
inhibit Power Manager from suspending the machine while playing

%package plugins-visualizer
Summary: Visualizer plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-visualizer
Plugin to the Rhythmbox music manager that provides
displays visualizations

%package plugins-mozilla
Summary: Browser plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release
Requires: browser-plugins-npapi

%description plugins-mozilla
Plugin for Mozilla based browsers to handle itms:// links

%package plugins-im-status
Summary: IM status plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-im-status
This plugin updates IM status according to the current song (works with
Empathy & Gossip)

%package plugins-notification
Summary: Status icon plugin for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-notification
Status icon and notification popups plugin for Rhythmbox

%package plugins-media-server
Summary: MediaServer2 D-Bus interface for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-media-server
This plugin provides an implementation of the MediaServer2 D-Bus
interface specification for Rhythmbox.

%package plugins-mpris
Summary: MPRIS D-Bus interface for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-mpris
This plugin provides an implementation of the MPRIS D-Bus interface
specification for Rhythmbox.

%package plugins-grilo
Summary: Grilo browser for Rhythmbox
Group: Sound
Requires: %name = %version-%release

%description plugins-grilo
A plugin to let you browse media content from various sources using
Grilo.

%package plugins-python
Summary: Python plugins for Rhythmbox
Group: Sound
Requires: %name = %version-%release
Requires: lib%name-gir = %version-%release

%package -n lib%name-gir
Summary: GObject introspection data for the Gedit
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Rhythmbox music manager/

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Rhythmbox
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Rhythmbox music manager.

%description plugins-python
Python scripting language capabilities and several Python plugins
to the Rhythmbox music manager.

%package plugins
Summary: All plugins for Rhythmbox
Group: Sound
BuildArch: noarch

Requires: %name-plugins-audioscrobbler = %version-%release
Requires: %name-plugins-cd-recorder = %version-%release
%{?_enable_daap:Requires: %name-plugins-daap = %version-%release}
Requires: %name-plugins-fmradio = %version-%release
Requires: %name-plugins-ipod = %version-%release
Requires: %name-plugins-iradio = %version-%release
Requires: %name-plugins-lirc = %version-%release
Requires: %name-plugins-mmkeys = %version-%release
Requires: %name-plugins-mtpdevice = %version-%release
Requires: %name-plugins-power-manager = %version-%release
%{?_enable_visualizer:Requires: %name-plugins-visualizer = %version-%release}
Requires: %name-plugins-im-status = %version-%release
Requires: %name-plugins-notification = %version-%release
Requires: %name-plugins-media-server = %version-%release
Requires: %name-plugins-mpris = %version-%release
%{?_enable_grilo:Requires: %name-plugins-grilo = %version-%release}
Requires: %name-plugins-python = %version-%release

%description plugins
This virtual package installs all Rhythmbox plugins

%prep
%setup -n %name-%version
%patch

%build
%autoreconf
export MOZILLA_PLUGINDIR=%browser_plugins_path
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--disable-static \
	--disable-schemas-compile \
	--disable-dependency-tracking \
	--enable-lirc \
	--with-brasero \
	--with-mtp \
	--with-ipod \
	%{subst_with hal} \
	%{subst_with gudev} \
	%{subst_with webkit} \
	%{subst_enable grilo}

%make_build

%install
%make DESTDIR=%buildroot install

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS DOCUMENTERS MAINTAINERS ChangeLog README* NEWS THANKS %buildroot%pkgdocdir/
bzip2 -9 %buildroot%pkgdocdir/ChangeLog
ln -s %_licensedir/GPL-2 %buildroot%pkgdocdir/COPYING

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/rhythmbox-metadata
%_libdir/%name/plugins/generic-player
%_libdir/%name/plugins/audiocd
%_datadir/%name
%_datadir/applications/*
%_datadir/dbus-1/services/*
%_datadir/icons/hicolor/*/*/*
%_man1dir/*
%config %_datadir/glib-2.0/schemas/org.gnome.rhythmbox.gschema.xml
%dir %pkgdocdir
%doc %pkgdocdir/AUTHORS
%doc %pkgdocdir/DOCUMENTERS
%doc %pkgdocdir/MAINTAINERS
%doc %pkgdocdir/COPYING
%doc %pkgdocdir/ChangeLog.bz2
%doc %pkgdocdir/NEWS
%doc %pkgdocdir/README
%doc %pkgdocdir/THANKS

%files -n lib%name
%_libdir/lib%name-core.so.*

%files -n lib%name-devel
%_libdir/lib%name-core.so
%_includedir/%name/
%_libdir/pkgconfig/%name.pc

%files plugins-audioscrobbler
%_libdir/%name/plugins/audioscrobbler/

%files plugins-cd-recorder
%_libdir/%name/plugins/cd-recorder/

%if_enabled daap
%files plugins-daap
%_libdir/%name/plugins/daap/
%endif

%files plugins-fmradio
%_libdir/%name/plugins/fmradio/

%files plugins-ipod
%_libdir/%name/plugins/ipod/

%files plugins-mtpdevice
%_libdir/%name/plugins/mtpdevice/

%files plugins-iradio
%_libdir/%name/plugins/iradio/

%files plugins-lirc
%_libdir/%name/plugins/rblirc/

%files plugins-mmkeys
%_libdir/%name/plugins/mmkeys/

%files plugins-power-manager
%_libdir/%name/plugins/power-manager/

%if_enabled visualizer
%files plugins-visualizer
%_libdir/%name/plugins/visualizer/
%endif

%files plugins-mozilla
%browser_plugins_path/librhythmbox-itms-detection-plugin.so
%exclude %browser_plugins_path/librhythmbox-itms-detection-plugin.la

%files plugins-im-status
%_libdir/%name/plugins/im-status/

%files plugins-notification
%_libdir/%name/plugins/notification/

%files plugins-media-server
%_libdir/%name/plugins/dbus-media-server/

%files plugins-mpris
%_libdir/%name/plugins/mpris/

%if_enabled grilo
%files plugins-grilo
%_libdir/%name/plugins/grilo/
%endif

%files -n lib%name-gir
%_libdir/girepository-1.0/MPID-3.0.typelib
%_libdir/girepository-1.0/RB-3.0.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/MPID-3.0.gir
%_datadir/gir-1.0/RB-3.0.gir

%files plugins-python
%_libdir/%name/plugins/rb/
%_libdir/%name/plugins/python-console/
%_libdir/%name/plugins/artsearch/
%_libdir/%name/plugins/lyrics/
%_libdir/%name/plugins/magnatune/
%{?_with_webkit:%_libdir/%name/plugins/context/}
%_libdir/%name/plugins/replaygain/
%_libdir/%name/plugins/sendto/
%_libdir/%name/plugins/rbzeitgeist/

%exclude %_libdir/%name/plugins/*/*.la
%exclude %browser_plugins_path/*.la

%files plugins

#%%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/rhythmbox/
#%%endif

%exclude %_libdir/%name/sample-plugins/

%changelog
