# This spec is backported to ALTLinux p7 automatically by rpmbph script from etersoft-build-utils.
#
# NOTE: do not use clean_spec or rpmcs for this spec

Name: rpm-build-altlinux-compat
Version: 2.1.1
Release: alt0.M70P.1

Summary: ALT Linux compatibility and extensions in rpm build

License: GPL
Group: Development/Other
Url: http://wiki.sisyphus.ru/devel/RpmBuildAltlinuxCompat

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: ftp://updates.etersoft.ru/pub/Etersoft/Sisyphus/sources/tarball/%name-%version.tar

BuildArchitectures: noarch

# Tune additional rpm macros file placement
%if %_vendor == "alt"
%define macrofilename macros
#ifndef _rpmmacrosdir
%if %{expand:%%{?_rpmmacrosdir:0}%%{!?_rpmmacrosdir:1}}
%define _rpmmacrosdir %_sysconfdir/rpm/macros.d
%endif
# see eterbug #10699 https://bugs.etersoft.ru/show_bug.cgi?id=10699
#BuildPreReq: altlinux-release
%else
# Provide includes macros
Provides: rpm-build-python rpm-build-perl rpm-macros-ttf rpm-build-licenses rpm-macros-cmake
# FreeBSD
%if %_vendor == "portbld" || %_vendor == "any"
%define _rpmmacrosdir /usr/local/etc/rpm
%define macrofilename macros
%else
# in Mandriva for example
%if %{expand:%%{?_sys_macros_dir:1}%%{!?_sys_macros_dir:0}}
%define _rpmmacrosdir %_sys_macros_dir
%define macrofilename 99-altlinux-compat.macros
%else
%define _rpmmacrosdir /etc/rpm
%define macrofilename macros
%endif
%endif

Requires: ed
# ALT has it in rpm, but regular rpm requires define it
BuildRoot: %{_tmppath}/%{name}-%{version}
%endif

Requires: rpm-build

%description
This package contains ALT Linux compatibility layer
and some extensions for rpm build
on various rpm running platforms.

%package -n rpm-build-intro
Summary: New macros for ALT Linux rpm build
Group: Development/Other
Requires: %_rpmmacrosdir
# we will use distr_vendor from it
# Requires: rpm-build-compat

%description -n rpm-build-intro
This package contains new macros introduced for
include in ALT Linux rpm build.

If you wish to use these macros, add rpm-build-intro
package to build requires.

%package -n rpm-macros-intro-conflicts
Summary: Conflicts macros for ALT Linux rpm build
Group: Development/Other
Requires: %_rpmmacrosdir
Requires: rpm-build-intro = %EVR

%description -n rpm-macros-intro-conflicts
This package contains conflicts macros for
use with ALT Linux rpm build.

If you wish to use these macros, add rpm-macros-intro-conflicts
package to build requires.

%package -n rpm-build-compat
Summary: ALT Linux compatibility macros for backport purposes
Group: Development/Other
Requires: %_rpmmacrosdir

%description -n rpm-build-compat
This package contains ALT Linux compatibility layer
for ALT Linux rpm build.
It is useful for backporting packages to previous ALT Linux distros.
Add it to buildrequires when backporting packages.
Command rpmbph from etersoft-build-utils will do it automatically.

%prep
%setup

%install
./install.sh %buildroot %_bindir %_rpmmacrosdir %macrofilename

%if %_vendor == "alt"

%files -n rpm-build-intro
%doc AUTHORS TODO
%_rpmmacrosdir/etersoft-intro

%files -n rpm-macros-intro-conflicts
%doc AUTHORS
%_rpmmacrosdir/etersoft-intro-conflicts

%files -n rpm-build-compat
%doc AUTHORS
%_rpmmacrosdir/compat
%_bindir/distr_vendor

%else

%files
%doc AUTHORS TODO ChangeLog
%_rpmmacrosdir/%macrofilename
%_bindir/add_changelog
%_bindir/stamp_spec
%_bindir/subst
%_bindir/distr_vendor

%endif

%changelog
