Name: rpm-utils
Version: 0.9.17
Release: alt1

Summary: Utilities every rpm packager must have
License: GPL
Group: Development/Other

Source: %name-%version.tar

Requires: getopt, time
Requires: rpm-build > 0:4.0.4-alt96.8, mktemp >= 1:1.3.1
# strace version that works properly without -F/-k options
Requires: strace >= 4.5.18-alt5

# Automatically added by buildreq on Wed Mar 26 2008
BuildRequires: gcc-c++ librpm-devel

%description
This package contains following utilities:
+ filereq - generates list of file requires while running the program;
+ packageof - generates list of packages owning specified files;
+ packagereq - generates list of package requires while running the program;
+ buildreq - generates and adds/updates BuildRequires tag in specfiles;
+ rpmdups,rpmrdups - generates list of duplicated packages;
+ rpmvercmp, rpmevrcmp: package version comparators;
+ stamp_spec - generates timestamp for rpm specfile changelog entry;
+ add_changelog - generates and adds changelog entry to rpm specfile;
+ compare_packages - generates lists of package sets and compares them;
+ cleanup_spec - attempts to cleanup rpm specfile;
+ rebuild_package - rebuilds source package keeping packager info unchanged;
+ rebuild_packages - rebuilds source packages using rebuild_package.

%prep
%setup

%build
%def_enable Werror
%make_build

%install
%makeinstall_std

%check
echo rpm-build |
	%buildroot%_datadir/buildreqs/optimize_package_list > out
[ "$(cat out)" = rpm-build ]

rpmquery -a --qf='%%{name}\n' |
	%buildroot%_datadir/buildreqs/optimize_package_list > out
grep -qs 'rpm-build' out
grep -qs 'librpm-devel' out
grep -qs 'gcc.*-c++' out

%files
%dir %_sysconfdir/buildreqs
%dir %_sysconfdir/buildreqs/*
%dir %_sysconfdir/buildreqs/files/*.d
%dir %_sysconfdir/buildreqs/packages/*.d
%config %_sysconfdir/buildreqs/files/*/*
%config %_sysconfdir/buildreqs/packages/essential*
%_bindir/*
%_datadir/buildreqs

%changelog
