%def_disable gssapi
%def_disable mmcount

Name: rsyslog
Version: 7.6.7
Release: alt0.M70P.1

Summary: Enhanced system logging and kernel message trapping daemon
License: GPLv3+ ASL2.0
Group: System/Kernel and hardware
Url: http://www.rsyslog.com
Provides: syslogd-daemon
Provides: /etc/rsyslog.d
PreReq: syslog-common

Conflicts: syslogd klogd
Conflicts: syslog-ng

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: flex
BuildRequires: zlib-devel
BuildRequires: libdbi-devel
BuildRequires: libmysqlclient-devel
BuildRequires: postgresql-devel
BuildRequires: libkrb5-devel
BuildRequires: librelp-devel >= 1.2.5
BuildRequires: libgnutls-devel libgcrypt-devel
BuildRequires: libnet-snmp-devel
BuildRequires: libnet-devel
BuildRequires: libestr-devel >= 0.1.9
BuildRequires: liblogging-devel >= 1.0.3
BuildRequires: libee-devel >= 0.4.0
BuildRequires: libjson-devel
BuildRequires: liblognorm-devel >= 0.3.1
BuildRequires: libmongo-client-devel >= 0.1.4
BuildRequires: libuuid-devel
BuildRequires: libcurl-devel
BuildRequires: libhiredis-devel >= 0.10.1
BuildRequires: libsystemd-journal-devel >= 197
BuildRequires: /usr/bin/rst2man

%define mod_dir /%_lib/%name

%description
Rsyslog is an enhanced multi-threaded syslogd supporting, among others, MySQL,
PostgreSQL, syslog/tcp, RFC 3195, permitted sender lists, filtering on any
message part, and fine grain output format control. It is quite compatible to
stock sysklogd and can be used as a drop-in replacement. Its advanced features
make it suitable for enterprise-class, encryption protected syslog relay chains
while  at the same time being very easy to setup for the novice user.

 o lmnet.so    - Implementation of network related stuff.
 o lmregexp.so - Implementation of regexp related stuff.
 o lmtcpclt.so - This is the implementation of TCP-based syslog clients.
 o lmtcpsrv.so - Common code for plain TCP based servers.
 o imtcp.so    - This is the implementation of the TCP input module.
 o imudp.so    - This is the implementation of the UDP input module.
 o imuxsock.so - This is the implementation of the Unix sockets input module.
 o imklog.so   - The kernel log input module for Linux.
 o imkmsg.so   - /dev/kmsg Log Input Module
 o immark.so   - This is the implementation of the build-in mark message input
                 module.
 o imfile.so   - This is the input module for reading text file data.

%package crypto
Summary: Encryption support
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description crypto
This package containes a module providing log file encryption and a
command line tool to process encrypted logs.

%package journal
Summary: Systemd journal support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description journal
The rsyslog-journal package contains a dynamic shared object that will add
systemd journal support to rsyslog.

 o imjournal.so - This is the implementation of the systemd journal input module.
 o omjournal.so - This is the implementation of the systemd journal output module.

%package mysql
Summary: MySQL support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mysql
The rsyslog-mysql package contains a dynamic shared object that will add
MySQL database support to rsyslog.

 o ommysql.so - This is the implementation of the build-in output module for
                MySQL.

%package pgsql
Summary: PostgreSQL support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description pgsql
The rsyslog-pgsql package contains a dynamic shared object that will add
PostgreSQL database support to rsyslog.

 o ompgsql.so - This is the implementation of the build-in output module for
                PgSQL.

%package mongo
Summary: MongoDB support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mongo
The rsyslog-mysql package contains a dynamic shared object that will add
MySQL database support to rsyslog.

 o ommongodb.so - This is the implementation of the build-in output module for
                MongoDB.

%package gssapi
Summary: GSS-API support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description gssapi
The rsyslog-gssapi package contains dynamic shared objects that will add
GSS-API support to rsyslog.

 o lmgssutil.so - This is a miscellaneous helper class for gss-api features.
 o imgssapi.so  - This is the implementation of the GSSAPI input module.
 o omgssapi.so  - This is the implementation of the build-in forwarding output
                  module.

%package gnutls
Summary: GNUTLS support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description gnutls
The rsyslog-gnutls package contains dynamic shared objects that will add
GNUTLS support to rsyslog.

 o lmnsd_gtls.so - This is a miscellaneous helper class for gnutls features.

%package relp
Summary: RELP support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description relp
The rsyslog-relp package contains a dynamic shared object that will add
RELP support to rsyslog.

 o imrelp.so - This is the implementation of the RELP input module.
 o omrelp.so - This is the implementation of the RELP output module.

%package dbi
Summary: Dbi support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description dbi
The rsyslog-dbi package contains a dynamic shared object that will add
dbi driver support to rsyslog.

 o omlibdbi.so - This is the implementation of the dbi output module.

%package snmp
Summary: SNMP support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description snmp
The rsyslog-snmp package contains a dynamic shared object that will add
SNMP support to rsyslog.

 o omsnmp.so - This module sends an snmp trap.

%package udpspoof
Summary: UDP forwarder with spoof the sender address for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description udpspoof
The rsyslog-udpspoof package contains a dynamic shared object that will add
UDP forwarder, but permits to spoof the sender address.

 o omudpspoof.so - This module permits to spoof the sender address.

%package mmaudit
Summary: Message modification module supporting Linux audit format
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mmaudit
The rsyslog-mmaudit package contains a dynamic shared object that will add
message modification supporting Linux audit format in various settings.

 o mmaudit.so - This module provides message modification supporting Linux audit format.

%package mmjsonparse
Summary: JSON enhanced logging support
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mmjsonparse
The rsyslog-mmaudit package contains a dynamic shared object that will add
capability to recognize and parse JSON enhanced syslog messages.

 o mmjsonparse.so - This module provides the capability to recognize and parse JSON enhanced
syslog messages.

%package mmnormalize
Summary: Log normalization support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mmnormalize
The rsyslog-mmaudit package contains a dynamic shared object that will add
normalize log messages via liblognorm.

 o mmnormalize.so  - This module provides the capability to normalize log messages via liblognorm.

%package mmanon
Summary: mmanon output module for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description mmanon
IP Address Anonimization Module (mmanon).
It is a message modification module that actually changes the IP address
inside the message, so after calling mmanon, the original message can
no longer be obtained. Note that anonymization will break digital
signatures on the message, if they exist.

%package elasticsearch
Summary: ElasticSearch output module for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description elasticsearch
The rsyslog-mmaudit package contains a dynamic shared object that will add
feed logs directly into Elasticsearch.

 o omelasticsearch.so - This module provides the capability for rsyslog to feed logs directly into
Elasticsearch.

%package hiredis
Summary: Redis support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description hiredis
The rsyslog-mmaudit package contains a dynamic shared object that will add
feed logs directly into Elasticsearch.

 o omhiredis.so - This module provides output to Redis.

%package extra
Summary: Extra support for rsyslog
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description extra
The rsyslog-extra package contains a dynamic shared object that will add
all other functions:

 o imptcp.so             - This is a native implementation of plain tcp input module with epool.
 o imttcp.so             - This is a native implementation of plain tcp input module with multiple thread.
 o omprog.so             - This output plugin enables rsyslog to execute a program and
                           feed it the message stream as standard input.
 o omuxsock.so           - This is the implementation of datgram unix domain socket forwarding.
 o pmaixforwardedfrom.so - This detects logs sent by AIX.
 o pmcisconames.so       - This detects logs sent by Cisco devices.
 o pmlastmsg.so          - This is a parser module specifically for those horrible
                           "<PRI>last message repeated n times" messages notoriously
                           generated by some syslog implementations.
 o pmsnare.so            - This detects logs sent by Snare.
 o mmsnmptrapd.so        - This is a message modification module. It takes messages generated
                           from snmptrapd and modifies them so that the look like they
                           originated from the real originator.
 o imdiag.so             - The testing module, which enables to talk to the rsyslog core at runtime
 o impstats.so           - Input Module to Generate Periodic Statistics of Internal Counters
 o omstdout.so           - stdout output module (stdout)

%package docs-html
Summary: HTML documentation for rsyslog
Group: Documentation
BuildArch: noarch

%description docs-html
This package contains the HTML documentation for rsyslog.

%prep
%setup -q
%patch -p1

%build
%autoreconf
# the hiredis-devel package doesn't provide a pkg-config file
export HIREDIS_CFLAGS=-I/usr/include/hiredis
export HIREDIS_LIBS=-lhiredis
%configure \
	--sbindir=/sbin \
	--libdir=/%_lib \
	--disable-static \
	--disable-testbench \
	--enable-elasticsearch \
	%{subst_enable mmcount} \
	--enable-gnutls \
	%{?_enable_gssapi:--enable-gssapi-krb5} \
	--enable-imdiag \
	--enable-imfile \
	--enable-imjournal \
	--enable-impstats \
	--enable-imptcp \
	--enable-imttcp \
	--enable-inet \
	--enable-klog \
	--enable-kmsg \
	--enable-largefile \
	--enable-libdbi \
	--enable-mail \
	--enable-mmanon \
	--enable-mmaudit \
	--enable-mmjsonparse \
	--enable-mmnormalize \
	--enable-mmsnmptrapd \
	--enable-mysql \
	--enable-omhiredis \
	--enable-ommongodb \
	--enable-omprog \
	--enable-omruleset \
	--enable-omstdout \
	--enable-omjournal \
	--enable-omudpspoof \
	--enable-omuxsock \
	--enable-pgsql \
	--enable-pmaixforwardedfrom \
	--enable-pmcisconames \
	--enable-pmlastmsg \
	--enable-pmrfc3164sd \
	--enable-pmsnare \
	--enable-regexp \
	--enable-relp \
	--enable-snmp \
	--enable-zlib \
	--enable-unlimited-select \
	--enable-usertools \
	--with-systemdsystemunitdir=%systemd_unitdir

%make_build

%install
%makeinstall_std
rm -f %buildroot%mod_dir/*.la

mkdir -p %buildroot{%_sysconfdir/{sysconfig,%name.d},%_initdir,%_var/spool/%name}

# fix html docs
rm -rf html_docs; mkdir -p html_docs
cp doc/*.html doc/*.jpg html_docs/
chmod 644 html_docs/*

install -m640 rsyslog.conf.alt %buildroot%_sysconfdir/%name.conf
install -m640 rsyslogd.alt %buildroot%_sysconfdir/sysconfig/rsyslogd
install -m755 rsyslogd.init %buildroot%_initdir/rsyslogd
install -m640 *_*.conf %buildroot%_sysconfdir/rsyslog.d/
install -m640 syslog.conf %buildroot%_sysconfdir/syslog.conf
install -m755 rsyslog-systemd.prestart %buildroot%systemd_unitdir/../altlinux-rsyslog-extrasockets
touch %buildroot%_sysconfdir/rsyslog.d/00_extrasockets.conf

# add aliase rsyslogd to rsyslog for systemd
ln -s rsyslog.service %buildroot%systemd_unitdir/rsyslogd.service
# add default start for systemd
mkdir -p %buildroot%systemd_unitdir/syslog.target.wants
ln -s ../rsyslog.service %buildroot%systemd_unitdir/syslog.target.wants/rsyslog.service

%post
%post_service rsyslogd

%preun
%preun_service rsyslogd

%files
%doc AUTHORS ChangeLog README  doc/rsyslog-example.conf
%config(noreplace) %attr(640,root,adm) %_sysconfdir/%name.conf
%config(noreplace) %attr(640,root,adm) %_sysconfdir/syslog.conf
%dir %_sysconfdir/%name.d/
%dir %_var/spool/%name
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_common.conf
%config(noreplace) %verify(not md5 size mtime) %attr(640,root,adm)  %ghost %_sysconfdir/rsyslog.d/00_extrasockets.conf
%config(noreplace) %_sysconfdir/sysconfig/rsyslogd
%config %_initdir/rsyslogd
%systemd_unitdir/*.service
%systemd_unitdir/../altlinux-rsyslog-extrasockets
%systemd_unitdir/syslog.target.wants/rsyslog.service
%dir %mod_dir
%mod_dir/imfile.so
%mod_dir/imklog.so
%mod_dir/imkmsg.so
%mod_dir/immark.so
%mod_dir/imtcp.so
%mod_dir/imudp.so
%mod_dir/imuxsock.so
%mod_dir/lmnet.so
%mod_dir/lmnetstrms.so
%mod_dir/lmnsd_ptcp.so
%mod_dir/lmregexp.so
%mod_dir/lmstrmsrv.so
%mod_dir/lmtcpclt.so
%mod_dir/lmzlibw.so
%mod_dir/lmtcpsrv.so
%mod_dir/ommail.so
%mod_dir/omruleset.so

/sbin/rsyslogd
%_mandir/man?/rsyslog*

%files crypto
%_bindir/rscryutil
%mod_dir/lmcry_gcry.so
%_man1dir/rscryutil.*

%files journal
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_journal.conf
%mod_dir/imjournal.so
%mod_dir/omjournal.so

%files mysql
%doc plugins/ommysql/createDB.sql plugins/ommysql/contrib/delete_mysql
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_mysql.conf
%mod_dir/ommysql.so

%files pgsql
%doc plugins/ompgsql/createDB.sql
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_pgsql.conf
%mod_dir/ompgsql.so

%files mongo
%_bindir/logctl
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_mongo.conf
%mod_dir/ommongodb.so

%if_enabled gssapi
%files gssapi
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_gssapi.conf
%mod_dir/omgssapi.so
%mod_dir/imgssapi.so
%mod_dir/lmgssutil.so
%endif

%files gnutls
%mod_dir/lmnsd_gtls.so

%files relp
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_relp.conf
%mod_dir/imrelp.so
%mod_dir/omrelp.so

%files dbi
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_dbi.conf
%mod_dir/omlibdbi.so

%files snmp
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_snmp.conf
%mod_dir/omsnmp.so

%files udpspoof
%config(noreplace) %attr(640,root,adm) %_sysconfdir/rsyslog.d/*_udpspoof.conf
%mod_dir/omudpspoof.so

%files mmaudit
%mod_dir/mmaudit.so

%files mmjsonparse
%mod_dir/mmjsonparse.so

%files mmnormalize
%mod_dir/mmnormalize.so

%files mmanon
%mod_dir/mmanon.so

%files elasticsearch
%mod_dir/omelasticsearch.so

%files hiredis
%mod_dir/omhiredis.so

%files extra
%mod_dir/imdiag.so
%mod_dir/imptcp.so
%mod_dir/imttcp.so
%mod_dir/impstats.so
%mod_dir/omprog.so
%mod_dir/omtesting.so
%mod_dir/omstdout.so
%mod_dir/omuxsock.so
%mod_dir/pmaixforwardedfrom.so
%mod_dir/pmcisconames.so
%mod_dir/pmlastmsg.so
%mod_dir/pmrfc3164sd.so
%mod_dir/pmsnare.so
%mod_dir/mmsnmptrapd.so

%files docs-html
%doc html_docs/*

%changelog
