%def_enable shared
%def_without valgrind
%def_enable rubygems
#define ruby_version %nil
%define libdir %_prefix/lib/%name
%define includedir %_includedir
%define ridir %_datadir/ri
%define vendordir %libdir/vendor_%name

Name: ruby
%define lname lib%name
%define branch 1.9
%define ver_teeny 3
%define _pl p537
Version: %branch.%ver_teeny
Release: alt44.M70P.1
Summary: An Interpreted Object-Oriented Scripting Language
License: BSD (revised) or Ruby
Group: Development/Ruby
URL: http://www.%name-lang.org/
Source0: ftp://ftp.%name-lang.org/pub/%name/%branch/%name-%version%{?_pl:-%_pl}.tar
Source1: update-ri-cache.rb
Patch: %name-%version-%release.patch
Requires: %lname = %version-%release

%define obsolete() \
Provides: %1 = %version-%release \
Obsoletes: %1
%define mobsolete() \
%(for m in %*; do \
echo "Provides: %name-module-$m = %version-%release"; \
echo "Obsoletes: %name-module-$m"; \
done)

BuildRequires: doxygen groff-base libdb4-devel libffi-devel
BuildRequires: libgdbm-devel libncursesw-devel libreadline-devel libssl-devel
BuildRequires: tk-devel zlib-devel libyaml-devel
BuildRequires: ruby ruby-stdlibs
BuildRequires: rpm-build-ruby >= 1:0.1.2
%{?_with_valgrind:BuildRequires: valgrind-devel}

%description
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains interpreter of object-oriented scripting language Ruby.


%package -n %lname
Summary: Ruby shared libraries
Group: System/Libraries
Provides: ruby(enumerator)

%description -n %lname
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby shared libraries.


%package -n %lname-devel
Summary: Files for compiling extension modules for Ruby
Group: Development/C
%{?_enable_shared:Requires: %lname = %version-%release}
# FIXME: remove require below
Requires: rpm-build-%name >= 0.1.2

%description -n %lname-devel
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains files, necessary to make extension library for Ruby.


%package -n %lname-devel-static
Summary: Files for compiling extension modules for Ruby
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains static Ruby library needed for embedding Ruby.


%package -n %name-stdlibs
Summary: Standard Ruby libraries
Group: Development/Ruby
Requires: %lname = %version-%release
Provides: %name-libs = %version-%release
Provides: %name-json = 1.5.5
Obsoletes: %name-json
Provides: %name-minitest = 2.5.1
Obsoletes: %name-minitest
#Provides: %name-module-test-unit = 2.2.0
#Obsoletes: %name-module-test-unit
Provides: %name-racc-runtime = 1.4.6
#Obsoletes: %name-racc-runtime
Provides: %{name}gems = 1.8.23.2
%mobsolete English bigdecimal cgi curses date-time dbm debug digest dl drb e2mmap
%mobsolete erb etc fcntl fileutils gdbm iconv math misc net nkf open3 openssl
%mobsolete optparse patterns pty readline rexml rss sdbm shell socket stringio
%mobsolete strscan syslog thread tracer uri wait webrick xmlrpc yaml zlib

%description -n %name-stdlibs
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains standard Ruby runtime libraries.


%package -n %name-tk
Summary: Standard Ruby libraries
Group: Development/Ruby
Requires: %lname = %version-%release
Requires: %name-stdlibs = %version-%release
Provides: %name-libs-tk = %version-%release
%obsolete %name-stdlibs-tk

%description -n %name-tk
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains standard Ruby Tk bindings libraries.


%package -n ri
Summary: Tool for display descriptions of built-in Ruby methods, classes, and modules
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
%obsolete %name-tool-ri
Conflicts: rdoc <= 1.9.3-alt10

%description -n ri
ri is a command line tool that displays descriptions of built-in Ruby methods,
classes, and modules. For methods, it shows  you  the  calling sequence  and
a description. For classes and modules, it shows a synopsis along with a list
of the methods the class or module implements.


%package tools
Summary: Ruby tools
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
Provides: gem = 1.8.23.2
#Provides: testrb
Provides: %name-rake = 0.9.2.2
Provides: rake = 0.9.2.2
Obsoletes: %name-rake
Provides: rdoc = %version-%release
Obsoletes: rdoc < %version-%release
%obsolete %name-tool-rdoc
#Provides: %name-test-unit = 2.2.0
#Obsoletes: %name-test-unit
Provides: %{name}gems = 1.8.24
Obsoletes: %{name}gems

%description tools
Ruby tools: rake, rdoc, gem.


%package -n irb
Summary: Interactive Ruby Shell
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
%obsolete %name-tool-irb

%description -n irb
irb is the REPL(read-eval&print loop) environment for Ruby programs.


%package doc-html
Summary: Ruby HTML documentatin
Group: Development/Documentation
BuildArch: noarch
AutoReq: no
AutoProv: no

%description doc-html
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby documentation in HTML format.


%package doc-ri
Summary: Ruby ri documentatin
Group: Development/Documentation
BuildArch: noarch
AutoReq: no
AutoProv: no
Requires: ri = %version-%release

%description doc-ri
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby documentation in ri format.


%prep
%setup -q %{?_pl:-n %name-%version-%_pl}
%patch -p1
sed -i -r '/^#[[:blank:]]*define[[:blank:]]+RUBY_API_VERSION_TEENY[[:blank:]]/s/(RUBY_API_VERSION_TEENY[[:blank:]]+).*$/\1%ver_teeny/' include/%name/version.h
chmod a-x sample/{optparse,rss}/*
# Broken 'require'
rm -f lib/rss/xmlscanner.rb
#sed -i "/^require[[:blank:]]\+'enumerator'/d" lib/rinda/tuplespace.rb
# Remove unneeded shebang
sed -i '/^#!/d' lib/minitest/spec.rb
# More strict shebang
sed -i '1s|^#!/usr/bin/env ruby|#!%_bindir/%name|' {lib/{abbrev,set},ext/tk/lib/tkextlib/pkg_checker}.rb
# Remove $ruby_version from libs path
sed -i 's|/\$(ruby_version)||g;s|\(/%name/\)#{version}/|\1|g' tool/mkconfig.rb
sed -i 's|/\${ruby_version}||' template/%name.pc.in
sed -i -r "s/File.join[[:blank:]]+(RbConfig::CONFIG\['ridir'\]),[[:blank:]]*version/\1/" lib/rdoc/ri/paths.rb
sed -i -r "/ridatadir[[:blank:]]*=/s/[[:blank:]]+CONFIG\['ruby_version'\],//" tool/rbinstall.rb
sed -i 's|[[:blank:]]*"/"RUBY_LIB_VERSION$||' version.c


%build
%autoreconf
%configure \
	%{subst_enable shared} \
	%{subst_with valgrind} \
	%{subst_enable rubygems} \
	--with-rubylibprefix=%libdir \
	--with-rubyhdrdir=%includedir \
	--with-ridir=%ridir \
	--docdir=%_docdir/%name-%version \
	%{?ruby_version:--with-ruby-version=%ruby_version} \
	--disable-rpath
%make_build


%install
%makeinstall_std
echo "VENDOR_SPECIFIC=true" > %buildroot%vendordir/vendor-specific.rb
install -p -m 0755 %{S:1} %buildroot%_bindir/update-ri-cache
ln -s %lname-static.a %buildroot%_libdir/%lname.a
mv %buildroot%_pkgconfigdir/%name{-%branch,}.pc
install -d -m 0755 %buildroot%_docdir/%name-%version
install -p -m 0644 COPYING* LEGAL NEWS README* ToDo %buildroot%_docdir/%name-%version/

# RI filetrigger
install -d -m 0755 %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/%name-doc-ri.filetrigger <<__EOF__
#!/bin/sh

LC_ALL=C grep -qs '^%ridir/site/' || exit 0
exec %_bindir/update-ri-cache %ridir/site
__EOF__
chmod +x %buildroot%_rpmlibdir/%name-doc-ri.filetrigger

%define __ruby %buildroot%_bindir/%name
%define ruby_libdir %libdir
%define ruby_arch %_target%([ -z "%_gnueabi" ] || echo "-eabi")
export RUBYLIB=%buildroot%libdir:%buildroot%libdir/%ruby_arch
export LD_LIBRARY_PATH=%buildroot%_libdir

%add_findreq_skiplist %libdir/gems/*/gems/*/bin/*


%check
%make_build test


%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/COPYING
%doc %_docdir/%name-%version/LEGAL
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README
%doc %_docdir/%name-%version/README.EXT
%doc %_docdir/%name-%version/ToDo
%lang(ja) %doc %_docdir/%name-%version/*.ja
%_bindir/%name
%_man1dir/%name.*


%files -n %lname
%{?_enable_shared:%_libdir/*.so.*}


%files -n %lname-devel
%_pkgconfigdir/*
%includedir/*
%{?_enable_shared:%_libdir/*.so}


%files -n %lname-devel-static
%_libdir/*.a


%files stdlibs
%libdir
%exclude %libdir/*/*tk*.so
%exclude %libdir/*tk*


%files tk
%libdir/*/*tk*.so
%libdir/*tk*


%files -n ri
%_bindir/update-ri-cache
%_bindir/ri
%_man1dir/ri.*
%_rpmlibdir/%name-doc-ri.filetrigger


%files tools
%_bindir/erb
%_bindir/gem
%_bindir/rake
%_bindir/rdoc
%exclude %_bindir/testrb
%_man1dir/erb.*
%_man1dir/rake.*


%files -n irb
%doc doc/irb/irb.rd
%lang(ja) %doc doc/irb/*.ja
%_bindir/irb
%_man1dir/irb.*


%files doc-html
%dir %_docdir/%name-%version
%_docdir/%name-%version/html


%files doc-ri
%dir %ridir
%ridir/*


%changelog
