%def_disable check

%define pkgname actionpack

Name: ruby-%pkgname
Version: 2.3.11
Release: alt1.1
Summary: Web-flow and rendering framework putting the VC in MVC.
License: MIT
Group: Development/Ruby
Url: http://rubyforge.org/projects/actionpack/

Requires: ruby-activesupport = %version
Requires: ruby-activerecord = %version

Source: %pkgname-%version.tar
Patch: %pkgname-%version-%release.patch

BuildArch: noarch

# Automatically added by buildreq on Tue Jul 08 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-activerecord-sqlite3-adapter ruby-builder ruby-i18n ruby-mocha ruby-rack ruby-redcloth ruby-tool-rdoc ruby-tool-setup

%description
Eases web-request routing, handling, and response as a half-way front,
half-way page controller. Implemented with specific emphasis on enabling
easy unit/integration testing that doesn't require a browser.

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%patch -p1
rm -rf lib/action_controller/vendor/rack*
%update_setup_rb

# Uses actionmailer
rm -f test/controller/assert_select_test.rb

# XXX@timonbl4: this tests not pass
rm -f test/activerecord/active_record_store_test.rb
rm -f test/controller/action_pack_assertions_test.rb
rm -f test/controller/cookie_test.rb
rm -f test/controller/integration_test.rb
rm -f test/controller/session/cookie_store_test.rb
rm -f test/controller/session/mem_cache_store_test.rb
rm -f test/template/number_helper_i18n_test.rb
rm -f test/controller/render_test.rb


%build
%ruby_config
%ruby_build


%install
%ruby_install
%rdoc lib/

# TODO for 2.x: remove lib/action_controller/vendor/ and package:
#  http://rubyforge.org/projects/scrapi (html-scanner)
# However, included scrAPI parts seems to be heavily patched...
%add_ruby_weakprov_path action_controller/vendor/html-scanner

%check
ruby -Ilib:test:. -e 'Dir["test/[cft]*/**/*_test.rb"].sort.each {|f| require f }'
ruby -Ilib:test:. -e 'Dir["test/activerecord/*_test.rb"].sort.each {|f| require f }'

%files
%doc CHANGELOG README
%ruby_sitelibdir/*

%files doc
%ruby_ri_sitedir/Action*

%changelog
