%def_disable check

%define pkgname activerecord

Name: ruby-%pkgname
Version: 2.3.11
Release: alt1.1
Summary: Implements the ActiveRecord pattern for ORM.
License: MIT
Group: Development/Ruby
Url: http://rubyforge.org/projects/activerecord/

Requires: ruby-activesupport = %version

Source: %pkgname-%version.tar
Patch:  %pkgname-%version-%release.patch

BuildArch: noarch

# Automatically added by buildreq on Tue Jul 08 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-activesupport ruby-builder ruby-mocha ruby-rake ruby-tool-rdoc ruby-tool-setup sqlite3 sqlite3-ruby tzdata

%description
Implements the ActiveRecord pattern (Fowler, PoEAA) for ORM. It ties
database tables and classes together for business objects, like Customer
or Subscription, that can find, save, and destroy themselves without
resorting to manual SQL.

%package mysql-adapter
Summary: MySQL connection adapter for ActiveRecord
Group: Development/Ruby
Requires: %name = %version-%release
# Hidden from ruby.req...
Requires: ruby(mysql)

%package postgresql-adapter
Summary: PostgreSQL connection adapter for ActiveRecord
Group: Development/Ruby
Requires: %name = %version-%release
# Hidden from ruby.req...
Requires: ruby(pg)

%package sqlite3-adapter
Summary: SQLite3 connection adapter for ActiveRecord
Group: Development/Ruby
Requires: %name = %version-%release
# Hidden from ruby.req...
Requires: ruby(sqlite3)

%description mysql-adapter
MySQL connection adapter for ActiveRecord.

%description postgresql-adapter
PostgreSQL connection adapter for ActiveRecord.

%description sqlite3-adapter
SQLite3 connection adapter for ActiveRecord.

%package doc
Summary: Documentation files for %pkgname
Group: Documentation

%description doc
Documentation files for %pkgname

%prep
%setup -q -n %pkgname-%version
%patch -p1
rm -rf lib/active_record/vendor
%update_setup_rb

# XXX@timonbl4: this tests not pass
rm -f test/cases/associations/join_model_test.rb
rm -f test/cases/finder_test.rb
rm -f test/cases/migration_test.rb
rm -f test/cases/validations_test.rb

%build
%ruby_config
%ruby_build


%install
%ruby_install
%rdoc lib/

%check
%rake test_sqlite3


%files
%doc CHANGELOG README
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/active_record/connection_adapters/[^a]*_adapter.rb

%files mysql-adapter
%ruby_sitelibdir/active_record/connection_adapters/mysql_adapter.rb

%files postgresql-adapter
%ruby_sitelibdir/active_record/connection_adapters/postgresql_adapter.rb

%files sqlite3-adapter
%ruby_sitelibdir/active_record/connection_adapters/sqlite_adapter.rb
%ruby_sitelibdir/active_record/connection_adapters/sqlite3_adapter.rb

%files doc
%doc examples
%ruby_ri_sitedir/ActiveRecord*

%changelog
