# vim: set ft=spec: -*- rpm-spec -*-

Name: ruby-gettext
Version: 2.1.0
Release: alt2.qa1.1

Summary: Native Language Support Library for Ruby
Group: Development/Ruby
License: LGPL
Url: http://rubyforge.org/projects/gettext/

BuildArch: noarch

Obsoletes: %name-cgi
Obsoletes: %name-erb
Provides: %name-cgi = %version-%release
Provides: %name-erb = %version-%release

# Automatically added by buildreq on Wed May 06 2009 (-bi)
BuildRequires: rpm-build-ruby ruby-locale ruby-racc-runtime ruby-rake ruby-tool-rdoc ruby-tool-setup
BuildRequires: ruby-test-unit

Source: %name-package-%version.tar
Patch: %name-%version-%release.patch

%description
Ruby GetText Package is Native Language Support Library and Tools
which modeled after GNU gettext package.

Features:
 * Simple APIs(similar GNU gettext)
 * rgettext creates po-files from ruby scripts.
   The po-file is compatible to GNU gettext.
 * rmsgfmt creates a mo-file from a po-file.

%package utils
Summary: GetText utils
Group: Development/Ruby

%description utils
GetText utils

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %name-package-%version
%patch -p1 
%update_setup_rb

%build
%ruby_config
%ruby_build
pushd test
%ruby_vendor -I../lib -e 'require "gettext/tools"; GetText.create_mofiles(:mo_root => "locale")'
find . -name 'test_*.rb' -print0 |
	xargs -r0 -n 1 %ruby_test_unit -I../lib -I./
popd

%install
%ruby_install
%rdoc lib/

%find_lang rgettext

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

%files
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/gettext/parser
%exclude %ruby_sitelibdir/gettext/tools
%exclude %ruby_sitelibdir/gettext/tools.rb
%exclude %ruby_sitelibdir/gettext/utils.rb
%doc README.rdoc

%files -f rgettext.lang utils
%_bindir/rgettext
%_bindir/rmsgfmt
%_bindir/rmsgmerge
%ruby_sitelibdir/gettext/parser
%ruby_sitelibdir/gettext/tools
%ruby_sitelibdir/gettext/tools.rb
%ruby_sitelibdir/gettext/utils.rb

%files doc
%doc samples ChangeLog*
%ruby_ri_sitedir/GetText*

%changelog
