# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname rack

Name: ruby-%pkgname
Version: 1.2.2
Release: alt1.1

Summary: Modular Ruby webserver interface
Group: Development/Ruby
License: MIT/Ruby
Url: http://rubyforge.org/projects/rack/

BuildArch: noarch

Source: %pkgname-%version.tar
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Sat Nov 01 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-tool-rdoc ruby-tool-setup

%description
Rack provides a minimal, modular and adaptable interface for developing
web applications in Ruby.  By wrapping HTTP requests and responses in
the simplest way possible, it unifies and distills the API for web
servers, web frameworks, and software in between (the so-called
middleware) into a single method call.

You may need to install appropriate %name-handler-XXX.

# Different handler autoload
%add_findreq_skiplist %ruby_sitelibdir/rack/handler.rb
# name Class file
%define ruby_rack_subpackage() \
%package handler-%1 \
Summary: %2 handler for Rack \
Group: Development/Ruby \
PreReq: %name = %version-%release \
\
%description handler-%1 \
%2 handler for Rack. \
\
%files handler-%1 \
%ruby_sitelibdir/rack/handler/%3.rb \
%nil

%ruby_rack_subpackage cgi CGI cgi
%ruby_rack_subpackage fastcgi FastCGI fastcgi
%ruby_rack_subpackage mongrel Mongrel mongrel
%ruby_rack_subpackage webrick WEBrick webrick

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%patch -p1
%update_setup_rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
%rdoc lib/

%files
%doc README KNOWN-ISSUES
%_bindir/rackup
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/rack/handler/*

%files doc
%doc example
%ruby_ri_sitedir/Rack*

%changelog
