%def_disable check

%define pkgname rails

Name: ruby-%pkgname
Version: 2.3.11
Release: alt1.1
Summary: Web-application framework with template engine, control-flow layer, and ORM.
License: MIT
Group: Development/Ruby
Url: http://www.rubyonrails.org

Source: railties-%version.tar
Patch: railties-%version-%release.patch

BuildArch: noarch

Requires: ruby-railties = %version-%release
Requires: ruby-rake >= 0.7.2

# Indirect dependencies
Requires: ruby(rack/handler/webrick) ruby-tool-irb

# Automatically added by buildreq on Wed Jul 09 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-actionmailer ruby-i18n ruby-mocha

# Do not process eruby templates
%add_findreq_skiplist %ruby_sitelibdir/rails_generator/generators/components/*/templates/*
# It only requires "modules", which belongs to application root
%add_findreq_skiplist %ruby_sitelibdir/console_*.rb
%add_findreq_skiplist %ruby_sitelibdir/commands/about.rb
%add_findreq_skiplist %ruby_sitelibdir/commands/performance/request.rb
# Used only by tasks/gems.rake
%add_findreq_skiplist %ruby_sitelibdir/rails/gem_builder.rb
# Templates
%add_findreq_skiplist %_datadir/%pkgname/configs/*
%add_findreq_skiplist %_datadir/%pkgname/dispatches/*
%add_findreq_skiplist %_datadir/%pkgname/doc/*
%add_findreq_skiplist %_datadir/%pkgname/environments/*
%add_findreq_skiplist %_datadir/%pkgname/helpers/*
%add_findreq_skiplist %_datadir/%pkgname/html/*

%description
Rails is a framework for building web-application using CGI, FCGI,
mod_ruby, or WEBrick on top of either MySQL, PostgreSQL, SQLite, DB2,
SQL Server, or Oracle with eRuby- or Builder-based templates.

This package contains development tools.

%package -n ruby-railties
Summary: Gluing the Engine to the Rails
Group: Development/Ruby
Requires: ruby-activesupport = %version
Requires: ruby-activerecord = %version
Requires: ruby-actionpack = %version
Requires: ruby-actionmailer = %version
Requires: ruby-activeresource = %version

%description -n ruby-railties
Rails is a framework for building web-application using CGI, FCGI,
mod_ruby, or WEBrick on top of either MySQL, PostgreSQL, SQLite, DB2,
SQL Server, or Oracle with eRuby- or Builder-based templates.

This package contains railties module.

%prep
%setup -q -n railties-%version
%patch -p1
find . -type f -print0 |
	xargs -r0 sed -i 's,/usr/local/bin/ruby,%_bindir/ruby,' --

# Uses rubygems
rm -f test/gem_dependency_test.rb
# Not compatible with test-unit 2.x
rm -f test/backtrace_cleaner_test.rb


%build


%install
mkdir -p %buildroot{%_bindir,%_datadir/%pkgname/plugins,%ruby_sitelibdir}
cp -rp lib/* %buildroot%ruby_sitelibdir
cp -rp bin builtin configs dispatches doc environments helpers html \
	fresh_rakefile README \
	%buildroot%_datadir/%pkgname
install -p -m755 bin/rails %buildroot%_bindir/rails
cat <<EOF > %buildroot%ruby_sitelibdir/railties_path.rb
RAILTIES_PATH = "%_datadir/%pkgname"
EOF
#rdoc lib/


%check
find test -type f -name '*_test.rb' -print0 | xargs -r0 -n1 ruby -Ilib:test


%files
%_bindir/*
%_datadir/%pkgname
%exclude %_datadir/%pkgname/plugins
%ruby_sitelibdir/commands*
%ruby_sitelibdir/tasks*
%ruby_sitelibdir/console_*.rb
%ruby_sitelibdir/*_server.rb
%ruby_sitelibdir/rails_generator*

%files -n ruby-railties
%dir %_datadir/%pkgname
%dir %_datadir/%pkgname/plugins
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/commands*
%exclude %ruby_sitelibdir/tasks*
%exclude %ruby_sitelibdir/console_*.rb
%exclude %ruby_sitelibdir/*_server.rb
%exclude %ruby_sitelibdir/rails_generator*

%changelog
