# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname rcairo

Name: ruby-%pkgname
Version: 1.10.0
Release: alt4.2

Summary: ruby bindings for cairo
Group: Development/Ruby
License: GPLv2/Ruby
Url: http://cairographics.org/rcairo
Obsoletes: rcairo < 1.7.0
Provides: rcairo = %version-%release

Source: %pkgname-%version.tar
Patch: %pkgname-%version-%release.patch

BuildPreReq: rpm-build-ruby
# Automatically added by buildreq on Thu May 17 2012 (-bi)
# optimized out: elfutils fontconfig libEGL-devel libGL-devel libX11-devel libruby-devel libwayland-client libwayland-server pkg-config python-base rpm-build-ruby ruby ruby-stdlibs xorg-xproto-devel
BuildRequires: libcairo-devel ruby-pkg-config libruby-devel

# buildreq misses a lot this time
BuildRequires: glib2-devel libpixman-devel xorg-glproto-devel xorg-dri2proto-devel libXau-devel libXdmcp-devel libXext-devel libXdamage-devel libXxf86vm-devel
BuildRequires: pkgconfig(expat)

%description
Ruby bindings for cairo // cairo extension for Ruby.

%package devel
Summary: Development files for %name
Group: Development/Ruby
Requires: %name = %version-%release
PreReq: libruby-devel
Obsoletes: rcairo-devel < 1.7.0
Provides: rcairo-devel = %version-%release
# due to #include <cairo.h>
Requires: libcairo-devel

%description devel
Ruby bindings for cairo // cairo extension for Ruby.

This package contains development files.

%prep
%setup -n %pkgname-%version
%patch -p1

%build
export RUBYOPT=-rvendor-specific
%ruby_configure
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS NEWS README.rdoc
%ruby_sitelibdir/*
%ruby_sitearchdir/*

%files devel
%doc samples
%_includedir/*

%changelog
